<?php

namespace Myvetshop\Module\Clinique\Cron;

use Symfony\Component\Console\Output\OutputInterface;

class MessagePurgeCronTask implements CronTaskInterface
{
    private \Db $db;

    public function __construct(
        \Db $db
    ) {
        $this->db = $db;
    }

    public function run(OutputInterface $output): void
    {
        $this->db->execute(
            'DELETE FROM `ps_message`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 2 YEAR)
              AND message LIKE "Numéro de paiement:%"
              AND id_employee=0'
        );

        $this->db->execute(
            'DELETE FROM `ps_message`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 2 YEAR)
              AND message LIKE "Notification envoyée sur l\'application mobile%"
              AND id_employee=0'
        );

        $this->db->execute(
            'DELETE FROM `ps_message`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 2 YEAR)
              AND message LIKE "ARC reçu de la centrale."'
        );

        $this->db->execute(
            'DELETE FROM `ps_message`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 2 YEAR)
              AND message LIKE "Commande transmise à la centrale %"'
        );

        $this->db->execute(
            'DELETE FROM `ps_message`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 2 YEAR)
              AND message LIKE "Alcyon#getsuivilignesResult%"'
        );

        $this->db->execute(
            'DELETE FROM `ps_message`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 2 YEAR)
              AND message LIKE "Alcyon#getCompteRendu%"'
        );

        $this->db->execute(
            'DELETE FROM `ps_message`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 2 YEAR)
              AND message LIKE "Cette commande a été passée depuis l\'application mobile"'
        );

        $this->db->execute('OPTIMIZE TABLE `ps_message`');

        $this->db->execute('DELETE FROM `ps_mail` WHERE recipient = "pra1.mvs@gmail.com"');

        $this->db->execute('DELETE FROM `ps_mail` WHERE date_add < DATE_SUB(NOW(), INTERVAL 2 YEAR)');

        $this->db->execute('OPTIMIZE TABLE `ps_mail`');
    }
}
