<?php

namespace Myvetshop\Module\Clinique\Api\Insight\Repository;

class InsightOrderDiscountRepository extends AbstractInsightRepository
{
    protected static function getTable(): string
    {
        return _DB_PREFIX_ . 'order_cart_rule';
    }

    protected static function getAlias(): string
    {
        return 'ocr';
    }

    protected static function getDefaultSelects(): array
    {
        return [
            'id' => 'ocr.id_cart_rule',
            'order_id' => 'ocr.id_order',
            'code' => 'cr.code',
            'name' => 'crl.name',
            'value_tax_excl' => 'ocr.value_tax_excl',
            'value_tax_incl' => 'ocr.value',
        ];
    }

    protected static function getJoins(): string
    {
        return
            ' LEFT JOIN ' . _DB_PREFIX_ . 'cart_rule cr ON cr.id_cart_rule=ocr.id_cart_rule'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'cart_rule_lang crl ON crl.id_cart_rule=ocr.id_cart_rule AND crl.id_lang=1'
        ;
    }
}
