<?php

class MyvetshopcliniqueMyRecoModuleFrontController extends ModuleFrontController
{
    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function initContent(): void
    {
        parent::initContent();

        $container = $this->getContainer();
        \assert(null !== $container);

        try {
            /** @var Myvetshop\Module\Clinique\Adapter\Controller\Front\MyRecoControllerAdapter $adapter */
            $adapter = $container
                ->get(Myvetshop\Module\Clinique\Adapter\Controller\Front\MyRecoControllerAdapter::class);

            $ret = $adapter->handleRequest(
                $this->context,
                Symfony\Component\HttpFoundation\Request::createFromGlobals()
            );

            if (isset($ret['errors'])) {
                $this->errors = $ret['errors'];
            }
            if (isset($ret['success'])) {
                $this->success = $ret['success'];
            }

            if (!$ret['template']) {
                $this->redirectWithNotifications(
                    $ret['redirect'] ?? $this->context->link->getModuleLink('myvetshopclinique', 'myreco')
                );

                return;
            } else {
                $this->setTemplate($ret['template']);
                $this->context->smarty->assign($ret['parameters']);
            }
        } catch (Exception $e) {
            $this->errors = [\get_class($e) . ' : ' . $e->getMessage()];
            $this->redirectWithNotifications($this->context->link->getPageLink('my-account', true));

            return;
        }
    }
}
