<?php

declare(strict_types=1);

class MyvetshopcliniqueMyAnimalsModuleFrontController extends ModuleFrontController
{
    /**
     * @throws PrestaShopException
     */
    public function initContent(): void
    {
        parent::initContent();

        /** @var \Myvetshop\Module\Clinique\Repository\AnimalRepository $animalRepository */
        $animalRepository = $this->container->get(\Myvetshop\Module\Clinique\Repository\AnimalRepository::class);
        $animals = $animalRepository->findBy(['idCustomer' => (int) $this->context->customer->id, 'deleted' => false]);

        $this->context->smarty->assign('animals', $animals);

        $this->setTemplate('module:myvetshopclinique/views/templates/front/animal/my_animals.tpl');
    }

    /**
     * @return array<mixed>
     */
    protected function getBreadcrumbLinks(): array
    {
        $breadcrumb = parent::getBreadcrumbLinks();

        $breadcrumb['links'][] = [
            'title' => $this->trans('My account', [], 'Shop.Navigation'),
            'url' => $this->context->link->getPageLink('my-account'),
        ];

        $breadcrumb['links'][] = [
            'title' => $this->trans('Mes animaux', [], 'Modules.Myvetshopclinique.Shop'),
            'url' => $this->getCurrentURL(),
        ];

        return $breadcrumb;
    }
}
