<?php

namespace App\Tests\A_Unit\Api\Insight\Serializer;

use Myvetshop\Module\Clinique\Api\Insight\Serializer\InsightOrderSerializer;
use PHPUnit\Framework\TestCase;

class InsightOrderSerializerTest extends TestCase
{
    public function testSerialize(): void
    {
        $dt = new \DateTimeImmutable();
        $orders = [
            [
                'id' => '1',
                'reference' => 'o.reference',
                'invoice_date' => $dt->format(\DateTimeInterface::ATOM),
                'state' => '21',
                'clinic_id' => '1',
                'supplier' => 'centravet',
                'clinic_privileged_code' => 'CLN123',
                'clinic_name' => 'Yesushi',
                'clinic_customer_code' => '1234',
            ],
        ];

        $orderElements = [
            'products' => [
                [
                    'id' => '1',
                    'supplier_code' => 'A49',
                    'name' => 'Chat Metabolic Poulet',
                    'format' => 'Sac de 3 kg',
                    'category_id' => '4',
                    'quantity' => '1',
                    'purchase_price' => '28.870000',
                    'total_price_tax_excl' => '48.080000',
                    'total_price_tax_incl' => ' 57.700000',
                    'order_id' => '1',
                    'manufacturer_id' => '5',
                ],
            ],
            'discounts' => [
                [
                    'id' => '1',
                    'order_id' => '1',
                    'value_tax_excl' => '4.000000',
                    'value_tax_incl' => '4.800000',
                ],
            ],
            'refunds' => [
                [
                    'id' => '1',
                    'order_id' => '1',
                    'total_products_tax_excl' => '10.000000',
                    'total_products_tax_incl' => '12.000000',
                    'total_shipping_tax_excl' => '0',
                    'total_shipping_tax_incl' => '0',
                ],
            ],
            'payments' => [
                [
                    'id' => '1',
                    'order_id' => '1',
                    'method' => 'Axepta',
                    'amount' => '48.080000',
                ],
            ],
        ];

        $expectedOrders = [
            [
                'id' => 1,
                'reference' => 'o.reference',
                'invoice_date' => $dt->format(\DateTimeInterface::ATOM),
                'state' => 21,
                'clinic_id' => 1,
                'supplier' => 'centravet',
                'clinic_privileged_code' => 'CLN123',
                'clinic_name' => 'Yesushi',
                'clinic_customer_code' => '1234',
                'products' => [
                    [
                        'id' => 1,
                        'supplier_code' => 'A49',
                        'name' => 'Chat Metabolic Poulet',
                        'format' => 'Sac de 3 kg',
                        'category_id' => 4,
                        'quantity' => 1,
                        'purchase_price' => '28.870000',
                        'total_price_tax_excl' => '48.080000',
                        'total_price_tax_incl' => ' 57.700000',
                        'manufacturer_id' => 5,
                    ],
                ],
                'discounts' => [
                    [
                        'id' => 1,
                        'value_tax_excl' => '4.000000',
                        'value_tax_incl' => '4.800000',
                    ],
                ],
                'refunds' => [
                    [
                        'id' => 1,
                        'total_products_tax_excl' => '10.000000',
                        'total_products_tax_incl' => '12.000000',
                        'total_shipping_tax_excl' => '0',
                        'total_shipping_tax_incl' => '0',
                    ],
                ],
                'payments' => [
                    [
                        'id' => 1,
                        'method' => 'Axepta',
                        'amount' => '48.080000',
                    ],
                ],
            ],
        ];

        $orders = InsightOrderSerializer::prepareOrdersArray($orders, $orderElements);

        self::assertEquals($expectedOrders, \json_decode((new InsightOrderSerializer())->serialize($orders), true));
    }
}
