<?php

namespace App\Tests\A_Unit\Accounting\Export\Exporter\Provider\Discount;

use Myvetshop\Module\Clinique\Accounting\Export\Exporter\Provider\Discount\DiscountProvider;
use PHPUnit\Framework\TestCase;

class DiscountProviderTest extends TestCase
{
    protected DiscountProvider $discountProvider;

    protected function setUp(): void
    {
        $this->discountProvider = new DiscountProvider();
    }

    public function testGetInvoiceAccountingLines(): void
    {
        $orderInvoice = $this->getMockBuilder(\OrderInvoice::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderInvoice->total_discount_tax_excl = 50;

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();

        $lines = $this->discountProvider->getInvoiceAccountingLines($orderInvoice, $order);

        self::assertCount(1, $lines);
        self::assertEquals('709700000', $lines[0]->getAccount());
        self::assertEquals(0.0, $lines[0]->getCredit());
        self::assertEquals(50.0, $lines[0]->getDebit());
    }

    public function testGetSlipAccountingLines(): void
    {
        $orderSlip = $this->getMockBuilder(\OrderSlip::class)
            ->disableOriginalConstructor()
            ->getMock();
        $orderSlip->order_slip_type = 1;

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();
        $order->total_discounts_tax_excl = 50;

        $lines = $this->discountProvider->getSlipAccountingLines($orderSlip, $order);

        self::assertCount(1, $lines);
        self::assertEquals('709700000', $lines[0]->getAccount());
        self::assertEquals(50.0, $lines[0]->getCredit());
        self::assertEquals(0.0, $lines[0]->getDebit());
    }
}
