<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Reporting\Normalizer;

use Jane\Component\JsonSchemaRuntime\Reference;
use Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Normalizer\CheckArray;
use Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Normalizer\ValidatorTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\DenormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareInterface;
use Symfony\Component\Serializer\Normalizer\NormalizerAwareTrait;
use Symfony\Component\Serializer\Normalizer\NormalizerInterface;

class OrdersGetResponse200ItemRefundsItemNormalizer implements DenormalizerInterface, NormalizerInterface, DenormalizerAwareInterface, NormalizerAwareInterface
{
    use DenormalizerAwareTrait;
    use NormalizerAwareTrait;
    use CheckArray;
    use ValidatorTrait;

    public function supportsDenormalization($data, $type, $format = null, array $context = []): bool
    {
        return $type === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemRefundsItem';
    }

    public function supportsNormalization($data, $format = null, array $context = []): bool
    {
        return is_object($data) && get_class($data) === 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemRefundsItem';
    }

    /**
     * @return mixed
     */
    public function denormalize($data, $class, $format = null, array $context = [])
    {
        if (isset($data['$ref'])) {
            return new Reference($data['$ref'], $context['document-origin']);
        }
        if (isset($data['$recursiveRef'])) {
            return new Reference($data['$recursiveRef'], $context['document-origin']);
        }
        $object = new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\OrdersGetResponse200ItemRefundsItem();
        if (null === $data || false === \is_array($data)) {
            return $object;
        }
        if (\array_key_exists('total_products_tax_excl', $data)) {
            $object->setTotalProductsTaxExcl($data['total_products_tax_excl']);
            unset($data['total_products_tax_excl']);
        }
        if (\array_key_exists('total_products_tax_incl', $data)) {
            $object->setTotalProductsTaxIncl($data['total_products_tax_incl']);
            unset($data['total_products_tax_incl']);
        }
        if (\array_key_exists('total_shipping_tax_excl', $data)) {
            $object->setTotalShippingTaxExcl($data['total_shipping_tax_excl']);
            unset($data['total_shipping_tax_excl']);
        }
        if (\array_key_exists('total_shipping_tax_incl', $data)) {
            $object->setTotalShippingTaxIncl($data['total_shipping_tax_incl']);
            unset($data['total_shipping_tax_incl']);
        }
        foreach ($data as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $object[$key] = $value;
            }
        }

        return $object;
    }

    /**
     * @return array|string|int|float|bool|\ArrayObject|null
     */
    public function normalize($object, $format = null, array $context = [])
    {
        $data = [];
        $data['total_products_tax_excl'] = $object->getTotalProductsTaxExcl();
        $data['total_products_tax_incl'] = $object->getTotalProductsTaxIncl();
        $data['total_shipping_tax_excl'] = $object->getTotalShippingTaxExcl();
        $data['total_shipping_tax_incl'] = $object->getTotalShippingTaxIncl();
        foreach ($object as $key => $value) {
            if (preg_match('/.*/', (string) $key)) {
                $data[$key] = $value;
            }
        }

        return $data;
    }

    public function getSupportedTypes(?string $format = null): array
    {
        return ['Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200ItemRefundsItem' => false];
    }
}
