<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint;

class GetOrders extends \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\BaseEndpoint implements \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\Endpoint
{
    use \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\EndpointTrait;

    /**
     * List orders
     *
     * @param array $queryParameters {
     *
     *     @var string $datemin Min date to filter orders
     *     @var string $datemax Max date to filter orders
     * }
     */
    public function __construct(array $queryParameters = [])
    {
        $this->queryParameters = $queryParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/orders';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['datemin', 'datemax']);
        $optionsResolver->setRequired(['datemin']);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('datemin', ['string']);
        $optionsResolver->addAllowedTypes('datemax', ['string']);

        return $optionsResolver;
    }

    /**
     * {@inheritdoc}
     *
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetOrdersBadRequestException
     * @throws \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetOrdersForbiddenException
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\OrdersGetResponse200Item[]|null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\OrdersGetResponse200Item[]', 'json');
        }
        if (400 === $status) {
            throw new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetOrdersBadRequestException($response);
        }
        if (403 === $status) {
            throw new \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Exception\GetOrdersForbiddenException($response);
        }
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }
}
