<?php

namespace Myvetshop\Module\Clinique\Generated\Jane\Reporting\Endpoint;

class GetDiscounts extends \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\BaseEndpoint implements \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\Endpoint
{
    use \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Runtime\Client\EndpointTrait;

    /**
     * List discounts
     *
     * @param array $queryParameters {
     *
     *     @var int $page Page to get
     * }
     */
    public function __construct(array $queryParameters = [])
    {
        $this->queryParameters = $queryParameters;
    }

    public function getMethod(): string
    {
        return 'GET';
    }

    public function getUri(): string
    {
        return '/discounts';
    }

    public function getBody(\Symfony\Component\Serializer\SerializerInterface $serializer, $streamFactory = null): array
    {
        return [[], null];
    }

    public function getExtraHeaders(): array
    {
        return ['Accept' => ['application/json']];
    }

    protected function getQueryOptionsResolver(): \Symfony\Component\OptionsResolver\OptionsResolver
    {
        $optionsResolver = parent::getQueryOptionsResolver();
        $optionsResolver->setDefined(['page']);
        $optionsResolver->setRequired([]);
        $optionsResolver->setDefaults([]);
        $optionsResolver->addAllowedTypes('page', ['int']);

        return $optionsResolver;
    }

    /**
     * {@inheritdoc}
     *
     * @return \Myvetshop\Module\Clinique\Generated\Jane\Reporting\Model\DiscountsGetResponse200Item[]|null
     */
    protected function transformResponseBody(\Psr\Http\Message\ResponseInterface $response, \Symfony\Component\Serializer\SerializerInterface $serializer, ?string $contentType = null)
    {
        $status = $response->getStatusCode();
        $body = (string) $response->getBody();
        if (is_null($contentType) === false && (200 === $status && mb_strpos($contentType, 'application/json') !== false)) {
            return $serializer->deserialize($body, 'Myvetshop\\Module\\Clinique\\Generated\\Jane\\Reporting\\Model\\DiscountsGetResponse200Item[]', 'json');
        }
    }

    public function getAuthenticationScopes(): array
    {
        return ['BearerAuth'];
    }
}
