<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_myvetshop_tarif_specifique")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\MyvetshopThemeRepository")
 */
class MyvetshopTarifSpecifique
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_tarif_specifique", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\Column(type="integer", name="id_product", nullable=false)
     */
    public int $idProduct;

    /**
     * @ORM\Column(type="integer", name="id_product_attribute", nullable=true)
     */
    public ?int $idProductAttribute = null;

    /**
     * @ORM\Column(type="decimal", name="tarif_privilege", precision=10, scale=4, nullable=true)
     *
     * @var numeric-string|null
     */
    public ?string $tarifPrivilege = null;

    /**
     * @ORM\Column(type="decimal", name="tarif_fardelage", precision=10, scale=4, nullable=true)
     *
     * @var numeric-string|null
     */
    public ?string $tarifFardelage = null;
}
