<?php

namespace Myvetshop\Module\Clinique\Api\Insight\Repository;

class InsightOrderProductRepository extends AbstractInsightRepository
{
    protected static function getTable(): string
    {
        return _DB_PREFIX_ . 'order_detail';
    }

    protected static function getAlias(): string
    {
        return 'od';
    }

    protected static function getDefaultSelects(): array
    {
        return [
            'id' => 'od.product_id',
            'order_id' => 'od.id_order',
            'supplier_code' => 'COALESCE(ps.product_supplier_reference,od.product_supplier_reference)',
            'name' => 'pl.name',
            'format' => 'al.name',
            'category' => 'CONCAT(cl.id_category, " - ", cl.name)',
            'manufacturer' => 'm.name',
            'quantity' => 'od.product_quantity',
            'total_price_tax_excl' => 'od.total_price_tax_excl',
            'total_price_tax_incl' => 'od.total_price_tax_incl',
        ];
    }

    protected static function getJoins(): string
    {
        return
            // Code produit du fabricant (ps.product_supplier_reference)
            ' LEFT JOIN ' . _DB_PREFIX_ . 'orders o ON o.id_order=od.id_order'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'myvetshop_clinique c ON o.id_carrier=c.id_carrier OR o.id_carrier=c.id_carrier_home'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'myvetshop_warehouse_supplier ws ON ws.id_warehouse=c.id_warehouse'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'product_supplier ps ON ps.id_product=od.product_id AND ps.id_product_attribute=od.product_attribute_id AND ps.id_supplier=ws.id_supplier'

            // Nom et format de produit (pl.name & al.name)
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'product_lang pl ON pl.id_product=od.product_id AND pl.id_lang=1 AND pl.id_shop=1'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'product_attribute_combination ac ON ac.id_product_attribute=od.product_attribute_id'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'attribute_lang al ON al.id_attribute=ac.id_attribute AND al.id_lang=1'

            // Catégorie (par défaut) du produit (s.id_category_default)
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'product_shop s ON s.id_product=od.product_id AND s.id_shop=1'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'category_lang cl ON cl.id_category=s.id_category_default AND cl.id_shop=1 AND cl.id_lang=1'

            // Fabricant du produit (p.id_manufacturer)
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'product p ON p.id_product=od.product_id'
            . ' LEFT JOIN ' . _DB_PREFIX_ . 'manufacturer m ON m.id_manufacturer=p.id_manufacturer'
        ;
    }
}
