<?php

namespace Myvetshop\Module\Clinique\Accounting\Legal;

class LegalTextGenerator
{
    public const NOAHVET = 'noahvet';
    public const VETZEN = 'vetzen';

    protected ?\DateTimeImmutable $transitionDate = null;

    public function getOrderLegalStructure(\Order $order): string
    {
        if (null === $this->transitionDate) {
            $transitionDateRaw = \Configuration::get('NOAHVET_TRANSITION_DATE');
            if ($transitionDateRaw) {
                $transitionDate = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $transitionDateRaw);
                if ($transitionDate) {
                    $this->transitionDate = $transitionDate;
                } else {
                    $this->transitionDate = new \DateTimeImmutable('+ 1 year');
                }
            }
        }

        /** @var \OrderPayment[] $payments */
        $payments = $order->getOrderPayments();

        $legalStructure = self::VETZEN;

        foreach ($payments as $payment) {
            if (\strtolower($payment->payment_method) === 'bnp paribas - axepta') {
                $legalStructure = self::NOAHVET;
            } elseif (
                \strtolower($payment->payment_method) === 'cm-cic'
                || \strtolower($payment->payment_method) === 'myvetshop paiements'
            ) {
                $legalStructure = self::VETZEN;
            } elseif (
                $this->transitionDate
                && \strtolower($payment->payment_method) === 'stripe'
                && strtotime($payment->date_add) >= $this->transitionDate->getTimestamp()
            ) {
                $legalStructure = self::NOAHVET;
            }
        }

        return $legalStructure;
    }

    public function getLegalStructureText(string $legalStructure): string
    {
        if ($legalStructure === self::VETZEN) {
            return 'VETZEN SAS'
                . ' - 115B AVENUE DU DRAPEAU 21000 DIJON'
                . ' - SIRET 82970806400037'
                . ' - TVA Intracommunautaire : FR26829708064';
        } elseif ($legalStructure === self::NOAHVET) {
            return 'NOAHVET SAS'
                . ' - 115B AVENUE DU DRAPEAU 21000 DIJON'
                . ' - SIRET 90230473200024'
                . ' - TVA Intracommunautaire : FR04902304732';
        } else {
            return $legalStructure;
        }
    }

    public function getOrderLegalText(\Order $order): string
    {
        return $this->getLegalStructureText($this->getOrderLegalStructure($order));
    }
}
