<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Bulk;

class BulkDocumentOrderAssociator
{
    /**
     * @template T of \OrderInvoice|\OrderSlip
     *
     * @param T[] $documents
     * @param \Order[] $orders
     *
     * @return list<array{0: T, 1: \Order}>
     */
    public function associate(array $documents, array $orders): array
    {
        /** @var array<int, \Order> $ordersById */
        $ordersById = \array_reduce(
            $orders,
            function (array $carry, \Order $order): array {
                $carry[(int) $order->id] = $order;

                return $carry;
            },
            []
        );

        return \array_map(
            fn ($document) => [$document, $ordersById[(int) $document->id_order]],
            $documents
        );
    }
}
