<?php

declare(strict_types=1);

use Myvetshop\Module\Clinique\Serializer\ClinicReportingSerializer;

require_once __DIR__ . '/reporting_init.php';

$clinics = Db::getInstance()->executeS(
    'SELECT'
    . ' c.id_myvetshop_clinique as "id"'
    . ', c.code_privilege as "code_privilege"'
    . ', sl.name as "name"'
    . ', sl.address1 as "address1"'
    . ', sl.address2 as "address2"'
    . ', s.postcode as "postcode"'
    . ', s.city as "city"'
    . ', c.deleted as "deleted"'
    . ' FROM ' . _DB_PREFIX_ . 'myvetshop_clinique c'
    . ' INNER JOIN ' . _DB_PREFIX_ . 'store s ON s.id_store=c.id_store'
    . ' INNER JOIN ' . _DB_PREFIX_ . 'store_lang sl ON sl.id_store=c.id_store AND sl.id_lang=1'
);

if (!\is_array($clinics)) {
    $clinics = [];
}

echo (new ClinicReportingSerializer())->serialize($clinics);
