{extends 'page.tpl'}

{block name='page_title'}
    {if isset($recommandation)}
        Recommandation Crokit pour votre {$recommandation.espece} {$recommandation.animal.nom}
    {else}
        {l s='Recommandation Crokit' d='Modules.Myvetshopclinique.Shop'}
    {/if}
{/block}

{block name='page_content_top'}

{/block}

{block name='page_content'}
    <div class="block-center">
        <div class="box">
            {if isset($recommandation)}
                {include file="module:myvetshopclinique/views/templates/front/myreco/_partials/_table_reco.tpl"}

                <p>
                    <span class="bold">
                        <a class="text-orange" href="{$link->getPageLink('my-account', true)|escape:'html'}">
                            Identifiez-vous
                        </a>
                        dès aujourd'hui sur Myvetshop pour commander vos aliments et bénéficier d'une remise
                        supplémentaire de 10%.</span>
                    <br>
                    Rappel du code privilège de votre clinique : <span
                            class="text-orange bold">{$recommandation.codePrivilege}</span> (à renseigner lors de votre
                    inscription)
                </p>
                <br>
                <div class="d-flex justify-content-center">
                    <a href="{$link->getPageLink('authentication', true)|escape:'html'}?create_account=1&code_privilege={$recommandation.codePrivilege}&back={$backurl}"
                       class="btn btn btn-primary">
                        <span>M'identifier</span>
                    </a>
                </div>
            {else}
                {include file="module:myvetshopclinique/views/templates/front/myreco/_partials/_add_recommandation.tpl"}
            {/if}
        </div>
    </div>
{/block}

{block name='page_footer'}

{/block}
