<?php

declare(strict_types=1);

if (!\defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_4_4_0(myvetshopclinique $module): bool
{
    $db = Db::getInstance();

    if (!$db->execute(
        'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'product_food` (
            `id_product_food` INT(11) NOT NULL AUTO_INCREMENT,
            `id_product` INT(11) NOT NULL,
            PRIMARY KEY (`id_product_food`),
            UNIQUE (`id_product`)
        )'
    )) {
        return false;
    }

    if (!$db->execute(
        'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'product_food_lang` (
            `id_product_food` INT(11) NOT NULL,
            `id_lang` INT(11) DEFAULT NULL,
            `type_aliment` VARCHAR(100) DEFAULT NULL,
            `utilisation` TEXT DEFAULT NULL,
            `composition` TEXT DEFAULT NULL,
            `constituants` TEXT DEFAULT NULL,
            `additifs` TEXT DEFAULT NULL,
            `valeur_energetique` TEXT DEFAULT NULL,
            `indications` TEXT DEFAULT NULL,
            `teneur_eau` TEXT DEFAULT NULL,
            PRIMARY KEY (`id_product_food`, `id_lang`)
        )'
    )) {
        return false;
    }

    if (!$db->execute(
        'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'myvetshop_tarif_specifique` (
            `id_tarif_specifique` INT(11) NOT NULL AUTO_INCREMENT,
            `id_product` INT(11) NOT NULL,
            `id_product_attribute` INT(11) DEFAULT NULL,
            `tarif_privilege` DECIMAL(10,2) DEFAULT NULL,
            `tarif_fardelage` DECIMAL(10,2) DEFAULT NULL,
            PRIMARY KEY (`id_tarif_specifique`),
            UNIQUE (`id_product`, `id_product_attribute`)
        )'
    )) {
        return false;
    }

    if (!$db->execute(
        'CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'myvetshop_warehouse_supplier` (
            `id_warehouse_supplier` INT(11) NOT NULL AUTO_INCREMENT,
            `id_warehouse` INT(11) NOT NULL,
            `id_supplier` INT(11) NOT NULL,
            PRIMARY KEY (`id_warehouse_supplier`),
            UNIQUE (`id_warehouse`)
        )'
    )) {
        return false;
    }

    // Configuration par défaut
    if (!Configuration::get('MYVETSHOP_SYNC_DIR')) {
        Configuration::set('MYVETSHOP_SYNC_DIR', '/var/myvetshop');
    }

    if (!Configuration::get('MYVETSHOP_DEFAULT_WAREHOUSE')) {
        Configuration::set('MYVETSHOP_DEFAULT_WAREHOUSE', '1');
    }

    return true;
}
