<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_product_food_lang")
 *
 * @ORM\Entity()
 */
class ProductFoodLang
{
    /**
     * @ORM\Id
     *
     * @ORM\ManyToOne(targetEntity="ProductFood", inversedBy="langs")
     * @ORM\JoinColumn(name="id_product_food", referencedColumnName="id_product_food", nullable=false)
     */
    public ?ProductFood $productFood = null;

    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", name="id_lang", nullable=false)
     */
    public int $idLang;

    /**
     * @ORM\Column(type="string", name="type_aliment", length=100, nullable=true)
     */
    public ?string $typeAliment = null;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    public ?string $utilisation = null;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    public ?string $composition = null;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    public ?string $constituants = null;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    public ?string $additifs = null;

    /**
     * @ORM\Column(type="text", name="valeur_energetique", nullable=true)
     */
    public ?string $valeurEnergetique = null;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    public ?string $indications = null;

    /**
     * @ORM\Column(type="text", name="teneur_eau", nullable=true)
     */
    public ?string $teneurEau = null;
}
