<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_product_food")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\ProductFoodRepository")
 */
class ProductFood
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", name="id_product_food", nullable=false)
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\Column(type="integer", name="id_product", nullable=false)
     */
    public int $idProduct;

    /**
     * @ORM\OneToMany(targetEntity="ProductFoodLang", mappedBy="productFood")
     *
     * @var Collection<int, ProductFoodLang>
     */
    protected Collection $langs;

    public function __construct()
    {
        $this->langs = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return Collection<int, ProductFoodLang>
     */
    public function getLangs(): Collection
    {
        return $this->langs;
    }

    public function addLang(ProductFoodLang $lang): self
    {
        $lang->productFood = $this;
        $this->langs->add($lang);

        return $this;
    }

    public function getLangById(int $idLang): ?ProductFoodLang
    {
        return $this->langs->filter(function (ProductFoodLang $lang) use ($idLang) {
            return $lang->idLang === $idLang;
        })->first() ?: null;
    }
}
