<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_animal_sac")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\AnimalSacRepository")
 *
 * @ORM\HasLifecycleCallbacks()
 */
class AnimalSac
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", name="id_animal_sac", nullable=false)
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\ManyToOne(targetEntity="Myvetshop\Module\Clinique\Entity\Animal", inversedBy="sacs", cascade={"remove"})
     *
     * @ORM\JoinColumn(name="id_animal", referencedColumnName="id_animal", onDelete="CASCADE", nullable=false)
     */
    public Animal $animal;

    /**
     * @ORM\Column(type="integer", name="id_product", nullable=false)
     */
    public int $idProduct;

    /**
     * @ORM\Column(type="integer", name="id_product_attribute", nullable=false)
     */
    public int $idProductAttribute;

    /**
     * @ORM\Column(type="string", length=255, name="product_name", nullable=true)
     */
    public ?string $productName = null;

    /**
     * @ORM\Column(type="string", length=10, name="product_reference", nullable=true)
     */
    public ?string $productReference = null;

    /**
     * @ORM\Column(type="string", length=14, name="product_ean13", nullable=true)
     */
    public ?string $productEan13 = null;

    /**
     * @ORM\Column(type="integer", length=10, name="id_order", nullable=true)
     */
    public ?int $idOrder = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_achat", nullable=false)
     */
    public \DateTimeImmutable $dateAchat;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_fin_estimee", nullable=false)
     */
    public \DateTimeImmutable $dateFinEstimee;

    /**
     * @ORM\Column(type="integer", name="poids_net", nullable=false)
     */
    public int $poidsNet;

    /**
     * @ORM\Column(type="integer", name="nombre_rations", nullable=true)
     */
    public ?int $nombreRations = null;

    /**
     * @ORM\Column(type="integer", name="nombre_rations_biais", nullable=false)
     */
    public int $nombreRationsBiais = 0;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_add", nullable=false)
     */
    protected ?\DateTimeImmutable $dateAdd = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_upd", nullable=false)
     */
    protected ?\DateTimeImmutable $dateUpd = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDateAdd(): ?\DateTimeImmutable
    {
        return $this->dateAdd;
    }

    public function getDateUpd(): ?\DateTimeImmutable
    {
        return $this->dateUpd;
    }
}
