<?php

namespace Myvetshop\Module\Clinique\Cron;

use Symfony\Component\Console\Output\OutputInterface;

class EstablishmentEventPurgeCronTask implements CronTaskInterface
{
    private \Db $db;

    public function __construct(
        \Db $db
    ) {
        $this->db = $db;
    }

    public function run(OutputInterface $output): void
    {
        $this->db->execute(
            'DELETE FROM `ps_establishment_event`
            WHERE `date_add` < DATE_SUB(NOW(), INTERVAL 1 MONTH) AND `event` = "order_updated"
            AND `id_establishment_event` NOT IN
            (
                SELECT MAX(id_myvetshop_clinique)
                FROM `ps_establishment_event` WHERE date_add < DATE_SUB(NOW(), INTERVAL 1 MONTH) AND `event` = "order_updated" GROUP BY `id_myvetshop_clinique`, `id_order`
            )'
        );

        $this->db->execute('OPTIMIZE TABLE `ps_establishment_event`');
    }
}
