<?php

namespace Myvetshop\Module\Clinique\Api;

use Ovh\Api;

class OvhApiFactory
{
    public function __construct()
    {
    }

    public function create(): Api
    {
        $ovhApplicationKey = \Configuration::get('OVH_APPLICATION_KEY');
        $ovhApplicationSecret = \Configuration::get('OVH_APPLICATION_SECRET');
        $ovhEndPoint = \Configuration::get('OVH_END_POINT');
        $ovhConsumerKey = \Configuration::get('OVH_CONSUMER_KEY');

        if (
            !$ovhApplicationKey
            || !$ovhApplicationSecret
            || !$ovhEndPoint
            || !$ovhConsumerKey) {
            throw new \Exception('OVH Not configured properly');
        }

        // @phpstan-ignore-next-line
        return new Api($ovhApplicationKey, $ovhApplicationSecret, $ovhEndPoint, $ovhConsumerKey);
    }
}
