<?php

namespace Myvetshop\Module\Clinique\Adapter\Repository;

use Myvetshop\Module\Clinique\Entity\MyvetshopClinique;

class GroupRepository
{
    /**
     * @param list<MyvetshopClinique> $cliniques
     *
     * @return list<\Group>
     */
    public function findGroupsForClinics(array $cliniques): array
    {
        $ret = [];

        foreach ($cliniques as $clinique) {
            if (null !== $clinique->idGroup) {
                $ret[] = new \Group($clinique->idGroup);
            }
            if (null !== $clinique->idGroupRural && $clinique->rurale) {
                $ret[] = new \Group($clinique->idGroupRural);
            }
        }

        return $ret;
    }
}
