<?php

namespace App\Tests\A_Unit\Presenter;

use Myvetshop\Module\Clinique\Entity\RecommandationProduct;
use Myvetshop\Module\Clinique\Presenter\RecommandationProductPresenter;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use PrestaShop\PrestaShop\Adapter\LegacyContext;

/**
 * Class RecommandationProductPresenterTest is a test class for RecommandationProductPresenter
 */
class RecommandationProductPresenterTest extends TestCase
{
    /**
     * @var \Context&object&MockObject
     */
    private \Context $context;

    /**
     * @var RecommandationProductPresenter&MockObject
     */
    private RecommandationProductPresenter $recommandationProductPresenter;

    protected function setUp(): void
    {
        $this->context = $this->createMock(\Context::class);
        $this->context->language = $this->createMock(\Language::class);
        $this->context->language->id = 1;

        $legacyContextMock = $this
            ->getMockBuilder(LegacyContext::class)
            ->disableOriginalConstructor()
            ->getMock();

        $legacyContextMock
            ->method('getContext')
            ->willReturn($this->context);

        $this->recommandationProductPresenter = $this->getMockBuilder(
            RecommandationProductPresenter::class,
        )
            ->onlyMethods(['getCover', 'getProduct'])
            ->setConstructorArgs([$legacyContextMock])
            ->getMock();
    }

    /**
     * Test present method
     */
    public function testPresent(): void
    {
        $this->recommandationProductPresenter
            ->expects($this->once())
            ->method('getCover')
            ->with(2)
            ->willReturn(['id_image' => 3, 'id_product' => 2, 'position' => 1, 'cover' => 1]);

        $product = $this->createMock(\Product::class);
        $product->id = 2;
        $this->recommandationProductPresenter
            ->expects($this->once())
            ->method('getProduct')
            ->with($product->id, $this->context)
            ->willReturn($product);

        $recommandationProductMock = $this->createMock(RecommandationProduct::class);
        $recommandationProductMock->method('getId')->willReturn(1);
        $recommandationProductMock->idProduct = 2;
        $recommandationProductMock->months = 10;
        $recommandationProductMock->quantity = 250;

        $result = $this->recommandationProductPresenter->present($recommandationProductMock);

        $this->assertIsArray($result);
        $this->assertArrayHasKey('id', $result);
        $this->assertArrayHasKey('months', $result);
        $this->assertArrayHasKey('quantity', $result);
        $this->assertArrayHasKey('product', $result);
        $this->assertArrayHasKey('image_id', $result);
        $this->assertSame(1, $result['id']);
        $this->assertSame($recommandationProductMock->months, $result['months']);
        $this->assertSame($recommandationProductMock->quantity, $result['quantity']);
        $this->assertSame($product, $result['product']);
        $this->assertSame(3, $result['image_id']);
    }
}
