<?php

namespace App\Tests\A_Unit\Domain\ProductAttribute;

use Myvetshop\Module\Clinique\Domain\ProductAttribute\ProductAttributeSorter;
use PHPUnit\Framework\TestCase;

class ProductAttributeSorterTest extends TestCase
{
    public function testSort(): void
    {
        $combinations = [
            10 => ['weight' => 5, 'name' => 'product 2'],
            11 => ['weight' => 2, 'name' => 'product 1'],
            12 => ['weight' => 9, 'name' => 'product 3'],
        ];

        ProductAttributeSorter::sort($combinations);

        $this->assertSame(
            [
                ['weight' => 2, 'name' => 'product 1'],
                ['weight' => 5, 'name' => 'product 2'],
                ['weight' => 9, 'name' => 'product 3'],
            ],
            \array_values($combinations)
        );

        $this->assertSame(
            [
                11,
                10,
                12,
            ],
            \array_keys($combinations)
        );
    }
}
