{extends 'page.tpl'}

{block name='page_title'}
    <span class="px-3">Mes animaux</span>
{/block}

{block name='page_content_top'}
    <p class="info-title px-3">
        Ajoutez les informations sur votre animal de compagnie. Pour plus d'options,
        <a href="#footer" class="text-primary hover-primary" style="text-decoration:underline;">téléchargez l'application MyVetshop.</a>
    </p>
{/block}

{block name='page_content'}
    {if empty($animals)}
        <p>
            Aucun animal, créez votre fiche animal !
        </p>
    {else}
        {foreach $animals as $animal}
            <div id="center_column" class="center_column pet-container col-12 col-sm-6 my-3">
                <div class="box">
                    <h1 class="page-subheading">{$animal->nom}</h1>
                    <p>
                        {$animal->espece|ucfirst}<br>
                        {$animal->race|ucfirst}<br>
                        {if $animal->idGender == 1}
                            Mâle
                        {else}
                            Femelle
                        {/if}
                        <br>
                        <br>
                        {if $animal->getRecommandationActive()}
                            Recommandation nutritionnelle vétérinaire :
                            <a target="_blank"
                               href="{$link->getModuleLink('myvetshopclinique', 'myreco')|escape:'htmlall':'UTF-8'}?action=pdf&id_recommandation={$animal->getRecommandationActive()->getId()}"
                               style="text-decoration: underline">consulter</a>
                        {else}
                            Aucune recommandation nutritionnelle vétérinaire
                        {/if}

                    </p>
                    <ul class="footer_links">
                        <a class="btn btn-primary btn-sm mr-3"
                           href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id_animal'=> $animal->getId()], true)|escape:'html'}"
                           title="Accueil">
                            <span>Mettre à jour <i class="fas fa-chevron-right"></i></span>
                        </a>
                        <button class="btn btn-primary btn-sm" data-toggle="modal"
                                data-target="#modal-delete-animal-{$animal->getId()}" title="Supprimer">
                            <span>Supprimer <i class="fas fa-times"></i></span>
                        </button>
                    </ul>
                </div>
            </div>
            <!-- Modal -->
            <div class="modal fade" id="modal-delete-animal-{$animal->getId()}" tabindex="-1" role="dialog"
                 aria-labelledby="modal-delete-animal-{$animal->getId()}-label">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            {* <button type="button" class="close close-modal" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>*}
                            <h4 class="modal-title" id="modal-delete-animal-{$animal->getId()}-label">Voulez-vous vraiment supprimer cet animal ?</h4>
                        </div>
                        <div class="modal-footer" style="border-top: 0">
                            <button type="button" class="close-modal btn btn-default" data-dismiss="modal">Annuler
                            </button>
                            <a type="button"
                               href="{$link->getModuleLink('myvetshopclinique', 'myanimal', ['id_animal'=> $animal->getId(), 'delete' => true], true)|escape:'html'}"
                               class="btn btn-danger">Supprimer</a>
                        </div>
                    </div>
                </div>
            </div>
        {/foreach}
    {/if}

{/block}

{block name='page_footer'}
    <div class="col">

        <div class="clearfix mb-4">
            <a class="btn btn-primary" title="Ajouter un animal"
               href="{$link->getModuleLink('myvetshopclinique', 'myanimal', [], true)|escape:'html'}">
                <span>Ajouter un animal <i class="fas fa-chevron-right"></i></span>
            </a>
        </div>

        <ul class="footer_links clearfix">
            <a class="btn btn-default button button-small hover-primary" href="{$urls.base_url}">
                <span><i class="fas fa-home"></i> Accueil</span>
            </a>
            <a class="btn btn-default button button-small hover-primary"
               href="{$link->getPageLink('my-account', true)|escape:'html'}">
                <span><i class="fas fa-chevron-left"></i> Retour à votre compte</span>
            </a>
        </ul>

    </div>
{/block}
