<?php

namespace Myvetshop\Module\Clinique\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\Query\ResultSetMapping;
use Doctrine\Persistence\ManagerRegistry;
use Myvetshop\Module\Clinique\Entity\MyvetshopTarifSpecifique;

class MyvetshopTarifSpecifiqueRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, MyvetshopTarifSpecifique::class);
    }

    public function purgeOlds(): void
    {
        $rsm = new ResultSetMapping();

        $query = $this->getEntityManager()
            ->createNativeQuery(
                'DELETE FROM `ps_myvetshop_tarif_specifique`'
                . ' WHERE `id_product_attribute` NOT IN (SELECT `id_product_attribute` FROM `ps_product_attribute`)'
                . ' AND `id_product_attribute` != 0',
                $rsm
            );

        $query->execute();
    }
}
