<?php

namespace Myvetshop\Module\Clinique\Prestashop\Hook;

use Myvetshop\Module\Clinique\Adapter\Hook\ActionObjectCliniqueAddAfterInterface;
use Myvetshop\Module\Clinique\Adapter\Hook\ActionObjectCliniqueUpdateAfterInterface;
use Myvetshop\Module\Clinique\Clinic\ClinicEmailRedirectionManager;

class RedirectionManagerListener implements ActionObjectCliniqueAddAfterInterface, ActionObjectCliniqueUpdateAfterInterface
{
    private ClinicEmailRedirectionManager $redirectionManager;

    public function __construct(
        ClinicEmailRedirectionManager $redirectionManager
    ) {
        $this->redirectionManager = $redirectionManager;
    }

    public function actionObjectCliniqueAddAfter(\Clinique $clinique): void
    {
        if ($clinique->email_original) {
            $this->redirectionManager->setRedirection($clinique->code_privilege, $clinique->email_original);
        }
    }

    public function actionObjectCliniqueUpdateAfter(\Clinique $clinique): void
    {
        if ($clinique->email_original) {
            $this->redirectionManager->setRedirection($clinique->code_privilege, $clinique->email_original);
        }
    }
}
