<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="ps_establishment_event")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\EstablishmentEventRepository")
 *
 * @ORM\HasLifecycleCallbacks()
 */
class EstablishmentEvent
{
    public const EVENT_CUSTOMER_DISABLED = 'customer_disabled';

    public const EVENT_CUSTOMER_JOIN = 'customer_join';

    public const EVENT_CUSTOMER_LEAVE = 'customer_leave';

    public const EVENT_CUSTOMER_UPDATE = 'customer_update';

    public const EVENT_ORDER_UPDATED = 'order_updated';

    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", name="id_establishment_event", nullable=false)
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\ManyToOne(targetEntity="Myvetshop\Module\Clinique\Entity\MyvetshopClinique")
     *
     * @ORM\JoinColumn(name="id_myvetshop_clinique", referencedColumnName="id_myvetshop_clinique", nullable=false)
     */
    public MyvetshopClinique $clinique;

    /**
     * See EstablishmentEvent::EVENT_XXX constants
     *
     * @ORM\Column(type="string", length=20, name="event", nullable=false)
     */
    public string $event;

    /**
     * Customer ID (only if event is customer_xxx).
     *
     * @ORM\Column(type="integer", name="id_customer", nullable=true)
     */
    public ?int $idCustomer = null;

    /**
     * Raw customer event data (JSON format, only filled if id_customer is not null).
     *
     * @ORM\Column(type="json", name="customer_data", nullable=true)
     *
     * @var array<array-key, mixed>
     */
    public ?array $customerData = null;

    /**
     * Order ID (only if event is order_updated).
     *
     * @ORM\Column(type="integer", name="id_order", nullable=true)
     */
    public ?int $idOrder = null;

    /**
     * Raw order event data (JSON format, only filled if id_order is not null).
     *
     * @ORM\Column(type="json", name="order_data", nullable=true)
     *
     * @var array<array-key, mixed>
     */
    public ?array $orderData = null;

    /**
     * @ORM\Column(type="datetime_immutable", name="date_add", nullable=false)
     */
    public ?\DateTimeImmutable $dateAdd = null;

    /**
     * @ORM\PrePersist()
     */
    public function prePersist(): void
    {
        if (!$this->dateAdd) {
            $this->dateAdd = new \DateTimeImmutable();
        }
    }

    public function getId(): ?int
    {
        return $this->id;
    }
}
