<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Model;

class SimpleAccountingLine implements SimpleAccountingLineInterface
{
    protected string $account;
    protected float $credit;
    protected float $debit;

    public function __construct(
        string $account,
        float $credit,
        float $debit
    ) {
        $this->account = \str_pad($account, 9, '0', STR_PAD_RIGHT);
        $this->credit = \round($credit, 2);
        $this->debit = \round($debit, 2);
    }

    public function getAccount(): string
    {
        return $this->account;
    }

    public function getCredit(): float
    {
        return $this->credit;
    }

    public function getDebit(): float
    {
        return $this->debit;
    }

    public function getAuxiliary(): string
    {
        switch ($this->account) {
            case '401000000':
                return 'FVENTEINTERNET';

            case '411000000':
                return '4110001';
        }

        return '';
    }
}
