<?php

namespace Myvetshop\Module\Clinique\Accounting\Export\Model;

class ExportLine
{
    protected \DateTimeImmutable $date;

    protected string $journal;

    protected string $account;

    protected string $auxiliary;

    protected string $entitled;

    protected string $docNumber;

    protected float $debit;

    protected float $credit;

    protected string $paymentMethod;

    public function __construct(
        \DateTimeImmutable $date,
        string $journal,
        string $account,
        string $auxiliary,
        string $entitled,
        string $docNumber,
        float $debit,
        float $credit,
        string $paymentMethod
    ) {
        $this->date = $date;
        $this->journal = $journal;
        $this->account = $account;
        $this->auxiliary = $auxiliary;
        $this->entitled = $entitled;
        $this->docNumber = $docNumber;
        $this->debit = $debit;
        $this->credit = $credit;
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * @return \DateTimeImmutable
     */
    public function getDate(): \DateTimeImmutable
    {
        return $this->date;
    }

    public function getJournal(): string
    {
        return $this->journal;
    }

    public function getAccount(): string
    {
        return $this->account;
    }

    public function getAuxiliary(): string
    {
        return $this->auxiliary;
    }

    public function getEntitled(): string
    {
        return $this->entitled;
    }

    public function getDocNumber(): string
    {
        return $this->docNumber;
    }

    public function getDebit(): float
    {
        return $this->debit;
    }

    public function getCredit(): float
    {
        return $this->credit;
    }

    public function getPaymentMethod(): string
    {
        return $this->paymentMethod;
    }

    public static function createFromSimpleLine(
        SimpleAccountingLineInterface $accountingLine,
        \DateTimeImmutable $documentDate,
        string $documentId,
        string $entitled,
        string $paymentMethod
    ): self {
        return new ExportLine(
            $documentDate,
            'VE WEB',
            $accountingLine->getAccount(),
            $accountingLine->getAuxiliary(),
            $entitled,
            $documentId,
            $accountingLine->getDebit(),
            $accountingLine->getCredit(),
            $paymentMethod,
        );
    }
}
