<?php

declare(strict_types=1);

// Si on est pas exécuté depuis la ligne de commande, ou si la mauvaise secure_key est envoyée, on arrête tout !
if ('cli' != \PHP_SAPI) {
    exit(1);
}

// Désactivation du timeout
set_time_limit(0);

// ///////////////////////////////////////////////
// Bootstrap PrestaShop
try {
    require_once __DIR__ . '/../../config/config.inc.php';

    // Gestion multi-boutique (au cas où) : Ce module est global
    if (Shop::isFeatureActive()) {
        Shop::setContext(Shop::CONTEXT_ALL);
    }
} catch (Exception $e) {
    echo $e->getMessage() . "\n" . $e->getTraceAsString();
    exit;
}

$context = Context::getContext();
\assert(null !== $context);

// Workaround pour PrestaShop
// @phpstan-ignore-next-line
$context->controller = (object) [
    'controller_type' => 'cron',
    'php_self' => 'cron',
];

// ///////////////////////////////////////////////
// / Classes spécifiques
require_once __DIR__ . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'Animal.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'AnimalSac.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . 'classes' . \DIRECTORY_SEPARATOR . 'CustomerPush.php';
require_once __DIR__ . \DIRECTORY_SEPARATOR . 'class' . \DIRECTORY_SEPARATOR . 'NotificationManager.php';

$db = Db::getInstance();

// / Récupération des sacs qui vont se terminer dans
$dateFinAlerte = (new DateTime('+12 days'))->format('Y-m-d');
$dateFinAlerteBis = (new DateTime('+6 days'))->format('Y-m-d');

$result = $db->executeS(
    'SELECT *'
    . ' FROM `ps_animal_sac` `as`'
    . ' WHERE `as`.`date_fin_estimee` = "' . $db->escape($dateFinAlerte) . '"'
    . ' OR `as`.`date_fin_estimee` = "' . $db->escape($dateFinAlerteBis) . '"'
);

if (!is_array($result)) {
    $result = [];
}

/** @var AnimalSac[] $animalSacs */
$animalSacs = ObjectModel::hydrateCollection(
    AnimalSac::class,
    $result
);

$notificationManager = new NotificationManager();

foreach ($animalSacs as $animalSac) {
    $animal = new Animal($animalSac->id_animal);
    // Ignore les animaux supprimés
    if ($animal->deleted) {
        continue;
    }

    // Nombre de nouveaux sac achetés
    $nbNewSac = $db->getValue(
        'SELECT COUNT(*)'
        . ' FROM `ps_animal_sac` `as`'
        . ' WHERE'
        . ' `as`.`id_animal` = ' . (int) $animalSac->id_animal
        . ' AND `as`.`date_achat` >= "' . $db->escape(date('Y-m-d')) . '"'
    );

    // Pas d'alerte si un sac a déjà été acheté
    if ($nbNewSac > 0) {
        continue;
    }

    // Récupère les identifiants PUSH pour cet animal

    $result = $db->executeS(
        'SELECT `cp`.*'
        . ' FROM `ps_customer_push` `cp`'
        . ' INNER JOIN `ps_oauth_access_token` `oat` ON `oat`.`id_oauth_access_token` =  `cp`.`id_oauth_access_token`'
        . ' WHERE `cp`.`id_customer` = ' . (int) $animal->id_customer
        . ' AND `cp`.`deleted` = 0'
        . ' AND `oat`.`expires` >= ' . time() . ' '
    );

    if (!is_array($result)) {
        $result = [];
    }

    /** @var CustomerPush[] $customerPushes */
    $customerPushes = ObjectModel::hydrateCollection(
        CustomerPush::class,
        $result
    );

    foreach ($customerPushes as $customerPush) {
        try {
            if ('chat' == $animal->espece) {
                $notificationManager->sendNotification(
                    $customerPush,
                    \mb_convert_encoding(
                        '&#128049; MIAOU ! ' . trim($animal->nom)
                        . " va avoir besoin d'un nouveau sac de croquettes !\nCliquez ici pour commander",
                        'UTF-8',
                        'HTML-ENTITIES'
                    )
                );
            } elseif ('chien' == $animal->espece) {
                $notificationManager->sendNotification(
                    $customerPush,
                    \mb_convert_encoding(
                        '&#128054; WOOF ! ' . trim($animal->nom)
                        . " va avoir besoin d'un nouveau sac de croquettes !\nCliquez ici pour commander",
                        'UTF-8',
                        'HTML-ENTITIES'
                    )
                );
            } else {
                $notificationManager->sendNotification(
                    $customerPush,
                    trim($animal->nom)
                    . " va avoir besoin d'un nouveau sac de croquettes !\nCliquez ici pour commander"
                );
            }
        } catch (Exception $e) {
            // Inhibiteur d'erreur
        }
    }
}
