<?php

class MyvetshopcliniqueRegistrationModuleFrontController extends FrontController
{
    public function displayAjaxCodePrivilege(): void
    {
        \header('Content-Type: application/json');

        /** @var string|int|false $idStoreRaw */
        $idStoreRaw = \Tools::getValue('id_store');

        if (false == $idStoreRaw) {
            \header('HTTP/1.0 400 Bad Request');
            $this->ajaxRender(\json_encode(['error' => 'id_store is required']) ?: null);

            return;
        }

        $container = $this->getContainer();
        if (!$container) {
            \header('HTTP/1.0 500 Internal Server Error');
            $this->ajaxRender(\json_encode(['error' => 'Container not initialized']) ?: null);

            return;
        }

        /** @var \Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository|null $cliniqueRepository */
        $cliniqueRepository = $container->get(
            \Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository::class
        );
        if (!$cliniqueRepository) {
            \header('HTTP/1.0 500 Internal Server Error');
            $this->ajaxRender(\json_encode(['error' => 'Repository not found']) ?: null);

            return;
        }

        $idStore = \intval($idStoreRaw);

        /** @var \Myvetshop\Module\Clinique\Entity\MyvetshopClinique|null $clinique */
        $clinique = $cliniqueRepository->findOneBy(['idStore' => $idStore]);

        if (!$clinique || $clinique->deleted) {
            \header('HTTP/1.0 404 Not Found');
            $this->ajaxRender(\json_encode(['error' => 'Veterinary Establishment not found']) ?: null);

            return;
        }

        $this->ajaxRender(\json_encode(['code' => $clinique->codePrivilege]) ?: null);
    }

    public function displayAjaxClinicInfo(): void
    {
        /** @var string|int|false $codePrivilege */
        $codePrivilege = \Tools::getValue('code_privilege');

        if (false == $codePrivilege || !\is_string($codePrivilege)) {
            \header('HTTP/1.0 400 Bad Request');
            $this->ajaxRender(\json_encode(['error' => 'Code privilège invalide : ' . $codePrivilege]) ?: null);

            return;
        }

        $container = $this->getContainer();
        if (!$container) {
            \header('HTTP/1.0 500 Internal Server Error');
            $this->ajaxRender(\json_encode(['error' => 'Container not initialized']) ?: null);

            return;
        }

        /** @var \Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository|null $cliniqueRepository */
        $cliniqueRepository = $container->get(
            \Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository::class
        );
        if (!$cliniqueRepository) {
            \header('HTTP/1.0 500 Internal Server Error');
            $this->ajaxRender(\json_encode(['error' => 'Repository not found']) ?: null);

            return;
        }

        /** @var \Myvetshop\Module\Clinique\Entity\MyvetshopClinique|null $clinique */
        $clinique = $cliniqueRepository->findByCodePrivilege($codePrivilege);

        if (!$clinique || $clinique->deleted) {
            \header('HTTP/1.0 404 Not Found');
            $this->ajaxRender('Clinique non trouvée');

            return;
        }

        $store = new \Store((int) $clinique->idStore, $this->context->language->id);

        $html = $this->context->smarty->fetch(
            'module:myvetshopclinique/views/templates/hook/registration_clinic_info.tpl',
            [
                'clinic' => $clinique,
                'store' => $store,
            ]
        );
        $this->ajaxRender($html);
    }

    public function displayAjaxLocateStores(): void
    {
        $container = $this->getContainer();
        \assert(null !== $container);

        try {
            /** @var Myvetshop\Module\Clinique\Adapter\Controller\Front\Registration\Store\StoreLocatorControllerAdapter $adapter */
            $adapter = $container
                ->get(Myvetshop\Module\Clinique\Adapter\Controller\Front\Registration\Store\StoreLocatorControllerAdapter::class);

            $ret = $adapter->handleRequest(
                $this->context,
                Symfony\Component\HttpFoundation\Request::createFromGlobals()
            );

            if (isset($ret['response'])) {
                $ret['response']->send();

                return;
            }
        } catch (\Symfony\Component\OptionsResolver\Exception\InvalidOptionsException $e) {
            \header('HTTP/1.0 400 Bad Request');
        } catch (Exception $e) {
            \PrestaShopLogger::addLog(
                $e->getMessage() . "\n" . $e->getTraceAsString(),
                3,
                $e->getCode(),
                'MyvetshopcliniqueRegistrationModuleFrontController::displayAjaxLocateStores'
            );

            \header('HTTP/1.0 500 Internal Server Error');

            return;
        }
    }

    public function displayAjaxSearchStores(): void
    {
        $container = $this->getContainer();
        \assert(null !== $container);

        try {
            /** @var Myvetshop\Module\Clinique\Adapter\Controller\Front\Registration\Store\StoreSearcherControllerAdapter $adapter */
            $adapter = $container
                ->get(Myvetshop\Module\Clinique\Adapter\Controller\Front\Registration\Store\StoreSearcherControllerAdapter::class);

            $ret = $adapter->handleRequest(
                $this->context,
                Symfony\Component\HttpFoundation\Request::createFromGlobals()
            );

            if (isset($ret['response'])) {
                $ret['response']->send();

                return;
            }
        } catch (\Symfony\Component\OptionsResolver\Exception\InvalidOptionsException $e) {
            \header('HTTP/1.0 400 Bad Request');
        } catch (Exception $e) {
            \PrestaShopLogger::addLog(
                $e->getMessage() . "\n" . $e->getTraceAsString(),
                3,
                $e->getCode(),
                'MyvetshopcliniqueRegistrationModuleFrontController::displayAjaxSearchStores'
            );
            \header('HTTP/1.0 500 Internal Server Error');
        }
    }
}
