<?php

namespace App\Tests\A_Unit\Accounting\Export\Repository;

use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderDetailRepository;
use PHPUnit\Framework\TestCase;

class OrderDetailRepositoryTest extends TestCase
{
    public function testGetByOrder(): void
    {
        $db = $this->getMockBuilder(\Db::class)
            ->disableOriginalConstructor()
            ->getMock();

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();
        $order->id = 1;

        $repository = new OrderDetailRepository($db);

        $db
            ->method('executeS')
            ->with('SELECT * FROM `pstest_order_detail` od WHERE od.id_order IN (1)')
            ->willReturn([
                [
                    'id_order_detail' => 10,
                    'id_order' => 1,
                ],
                [
                    'id_order_detail' => 11,
                    'id_order' => 1,
                ],
            ]);

        // Preload objects
        $repository->preload([$order]);

        $details = $repository->getByOrder($order);

        self::assertCount(2, $details);
        self::assertEquals(10, $details[0]->id);
        self::assertEquals(11, $details[1]->id);
    }
}
