<?php

namespace Myvetshop\Module\Clinique\Import\Kalivet\Serializer;

use Myvetshop\Module\Clinique\Import\Kalivet\Model\CustomerModel;

class CustomerModelNormalizer extends \Myvetshop\Module\Clinique\Import\Serializer\CustomerModelNormalizer
{
    /**
     * @param array<mixed> $context
     *
     * @return CustomerModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        /** @var CustomerModel $ret */
        $ret = parent::denormalize($data, $type, $format, ['object' => new CustomerModel()]);

        \assert(\is_array($data));

        $ret->idChezMonVetoInterface = null !== $data['id_chezmonvetointerface']
            ? \intval($data['id_chezmonvetointerface']) : null;
        $ret->idVetoCmv = null !== $data['id_veto_cmv']
            ? \intval($data['id_veto_cmv']) : null;
        $ret->idVetoAlcyon = $data['id_veto_alcyon'];

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return CustomerModel::class === $type;
    }
}
