<?php

namespace Myvetshop\Module\Clinique\Command\Sync;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class SyncAllCommand extends Command
{
    private SyncCategoriesCommand $syncCategoriesCommand;

    public function __construct(
        SyncCategoriesCommand $syncCategoriesCommand
    ) {
        parent::__construct('app:sync:all');

        $this->syncCategoriesCommand = $syncCategoriesCommand;
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        if (0 !== $this->syncCategoriesCommand->run($input, $output)) {
            return 1;
        }

        return 0;
    }
}
