<?php

namespace Myvetshop\Module\Clinique\Adapter\Repository;

class GroupReductionRepository
{
    public function getValueForProduct(int $idProduct, int $groupId): float
    {
        return (float) \GroupReduction::getValueForProduct($idProduct, $groupId);
    }

    /**
     * @param list<\Group> $groups
     *
     * @return array<int, float>
     */
    public function getReductionForGroups(int $idProduct, array $groups): array
    {
        $ret = [];

        foreach ($groups as $group) {
            $ret[(int) $group->id] = $this->getValueForProduct(
                $idProduct,
                (int) $group->id
            );
        }

        return $ret;
    }
}
