<?php

declare(strict_types=1);

/**
 * @property MyVetshopClinique $module
 * @property CliniqueHolidays $object
 *                                    Class AdminMyVetShopCliniqueHolidaysController
 */
class AdminMyVetShopCliniqueHolidaysController extends ModuleAdminController
{
    private Clinique $clinique;

    public function __construct()
    {
        parent::__construct();

        $this->bootstrap = true;
        $context = Context::getContext();
        \assert(null !== $context);
        $this->context = $context;
        $this->table = CliniqueHolidays::TABLE;
        $this->className = CliniqueHolidays::class;
        $this->identifier = strval(CliniqueHolidays::$definition['primary']);

        $this->allow_export = true;
        $this->lang = false;

        $this->loadObject(true);

        $clinique = null;

        $idMyvetshopClinique = Tools::getValue('id_myvetshop_clinique');

        if (\is_string($idMyvetshopClinique) || \is_int($idMyvetshopClinique)) {
            $idMyvetshopClinique = \intval($idMyvetshopClinique);
        } else {
            $idMyvetshopClinique = 0;
        }

        $clinique = Clinique::getByCliniqueId($idMyvetshopClinique);

        if (Validate::isLoadedObject($this->object)) {
            $clinique = Clinique::getByCliniqueId((int) $this->object->id_myvetshop_clinique);
        }

        if (!$clinique) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminMyVetShopClinique'));
            exit;
        }

        $this->clinique = $clinique;

        $this->_where = ' AND id_myvetshop_clinique=' . $this->clinique->id;
        $this->_orderBy = 'a.id_myvetshop_clinique_holidays';

        $this->fields_list = [
            'id_myvetshop_clinique_holidays' => [
                'title' => $this->l('ID'),
                'align' => 'text-center',
                'class' => 'fixed-width-xs',
            ],
            'id_myvetshop_clinique' => [
                'title' => $this->l('Clinique'),
                'havingFilter' => false,
                'callback' => 'printClinique',
            ],
            'date_alerte' => [
                'title' => $this->l('Date alerte'),
                'align' => 'text-center',
            ],
            'date_debut' => [
                'title' => $this->l('Date début'),
                'align' => 'text-center',
            ],
            'date_fin' => [
                'title' => $this->l('Date fin'),
                'align' => 'text-center',
            ],
        ];
        $this->bulk_actions = [
            'delete' => [
                'text' => $this->l('Delete selected'),
                'icon' => 'icon-trash',
                'confirm' => $this->l('Delete selected object?'),
            ],
        ];

        // Actions disponibles
        $this->addRowAction('edit');
        $this->addRowAction('delete');
    }

    public function initToolbar(): void
    {
        parent::initToolbar();

        $url = $this->context->link->getAdminLink($this->controller_name);

        if (isset($this->toolbar_btn['new'])) {
            $this->toolbar_btn['new']['href'] = $url
                . '&addmyvetshop_clinique_holidays&id_myvetshop_clinique=' . $this->clinique->id;
        }
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws SmartyException
     */
    public function renderForm(): string
    {
        $this->fields_form = [
            'legend' => [
                'title' => 'edit' == $this->display
                    ? $this->l('Modifier une période de vacances')
                    : $this->l('Ajouter une période de vacances'),
                'icon' => 'icon-angle-double-right',
            ],
            'input' => [
                [
                    'type' => 'date',
                    'label' => $this->l('Date alerte'),
                    'name' => 'date_alerte',
                    'required' => false,
                    'col' => '3',
                ],
                [
                    'type' => 'textarea',
                    'label' => $this->l("Message d'alerte"),
                    'name' => 'message_alerte',
                    'required' => false,
                ],
                [
                    'type' => 'date',
                    'label' => $this->l('Date début'),
                    'name' => 'date_debut',
                    'required' => true,
                    'col' => '3',
                ],
                [
                    'type' => 'date',
                    'label' => $this->l('Date fin'),
                    'name' => 'date_fin',
                    'required' => true,
                    'col' => '3',
                ],
                [
                    'type' => 'textarea',
                    'label' => $this->l('Message'),
                    'name' => 'message',
                    'required' => true,
                ],
                [
                    'type' => 'hidden',
                    'name' => 'id_myvetshop_clinique',
                    'default_value' => $this->clinique->id,
                ],
            ],
            'submit' => [
                'title' => $this->l('Save'),
                'class' => 'btn btn-default pull-right',
                'name' => 'saveAction',
            ],
        ];

        return parent::renderForm();
    }

    public function printClinique(int $cliniqueId): string
    {
        return (new Clinique($cliniqueId))->name;
    }

    protected function afterAdd($object)
    {
        return $this->afterUpdate($object);
    }

    /**
     * @return bool
     *
     * @throws PrestaShopException
     */
    protected function afterUpdate($cliniqueHolidays)
    {
        \assert($cliniqueHolidays instanceof CliniqueHolidays);

        Tools::redirectAdmin(
            $this->context->link->getAdminLink($this->controller_name)
            . '&id_myvetshop_clinique=' . $cliniqueHolidays->id_myvetshop_clinique
        );

        return true;
    }

    protected function afterDelete($object, $old_id)
    {
        return parent::afterUpdate($object);
    }
}
