<?php

namespace App\Tests\A_Unit\Api\Crokit\Normalizer;

use Myvetshop\Module\Clinique\Api\Crokit\Dto\CrokitRecommandation;
use Myvetshop\Module\Clinique\Api\Crokit\Normalizer\CrokitRecommandationNormalizer;
use PHPUnit\Framework\TestCase;

class CrokitRecommandationNormalizerTest extends TestCase
{
    public function testDenormalize(): void
    {
        $normalizer = new CrokitRecommandationNormalizer();
        $data = [
            'date' => '16-04-2024',
            'code' => 'CLM296',
            'petname' => 'ROCKET',
            'esp' => 'chien',
            'race' => 'Beagle',
            'sex' => 'Mâle castré',
            'act' => 'Calme : moins d\'une heure de promenade par jour',
            'age' => '3 an(s)',
            'dob' => '25-10-2020',
            'stadePhysio' => 'adulte',
            'patho' => 'aucune',
            'actualw' => '16',
            'idealw' => '15',
            'be' => '571',
            'nbrAliment' => 1,
            'productIDmvs1' => '10638',
            'productIDmvs2' => null,
            'productIDmvs3' => null,
            'qteAliment1' => '145',
            'qteAliment2' => '',
            'qteAliment3' => '',
            'transition12' => '',
            'transition23' => '',
        ];

        $result = $normalizer->denormalize($data, CrokitRecommandation::class);

        $this->assertInstanceOf(CrokitRecommandation::class, $result);
        $this->assertEquals('CLM296', $result->code);
    }

    /**
     * Tests the denormalize method with invalid date.
     */
    public function testDenormalizeInvalidDate(): void
    {
        $this->expectException(\Exception::class);
        $this->expectExceptionMessage('Invalid date');

        $normalizer = new CrokitRecommandationNormalizer();
        $data = ['date' => 'invalid-date'];
        $normalizer->denormalize($data, CrokitRecommandation::class);
    }

    /**
     * Tests the denormalize method with a JSON input.
     */
    public function testDenormalizeWithJsonInput(): void
    {
        $normalizer = new CrokitRecommandationNormalizer();
        $json = '[{"date":"16-04-2024","code":"CLM296","petname":"ROCKET","esp":"chien","race":"Beagle","sex":"Mâle castré","act":"Calme : moins d\'une heure de promenade par jour","age":"3 an(s)","dob":"25-10-2020","stadePhysio":"adulte","patho":"aucune","actualw":"16","idealw":"15","be":"571","nbrAliment":1,"productIDmvs1":"10638","productIDmvs2":null,"productIDmvs3":null,"qteAliment1":"145","qteAliment2":"","qteAliment3":"","transition12":"","transition23":""}]';
        $data = \json_decode($json, true);

        $result = $normalizer->denormalize($data[0], CrokitRecommandation::class);

        $this->assertInstanceOf(CrokitRecommandation::class, $result);
        $this->assertEquals('CLM296', $result->code);
    }
}
