<?php

namespace App\Tests\A_Unit\Accounting\Export\Repository;

use Myvetshop\Module\Clinique\Accounting\Export\Repository\OrderDetailTaxRepository;
use PHPUnit\Framework\TestCase;

class OrderDetailTaxRepositoryTest extends TestCase
{
    public function testGetByOrder(): void
    {
        $db = $this->getMockBuilder(\Db::class)
            ->disableOriginalConstructor()
            ->getMock();

        $order = $this->getMockBuilder(\Order::class)
            ->disableOriginalConstructor()
            ->getMock();
        $order->id = 1;

        $repository = new OrderDetailTaxRepository($db);

        $db
            ->method('executeS')
            ->with('SELECT od.id_order, od.id_order_detail, odt.total_amount AS amount, t.rate'
                . ' FROM `pstest_order_detail` od'
                . ' INNER JOIN `pstest_order_detail_tax` odt ON odt.id_order_detail = od.id_order_detail'
                . ' INNER JOIN `pstest_tax` t ON t.id_tax = odt.id_tax WHERE od.id_order IN (1)')
            ->willReturn([
                [
                    'id_order_detail' => 10,
                    'id_order' => 1,
                    'amount' => '11.080000',
                    'rate' => '20.000',
                ],
                [
                    'id_order_detail' => 11,
                    'id_order' => 1,
                    'amount' => '1.490000',
                    'rate' => '20.000',
                ],
            ]);

        // Preload objects
        $repository->preload([$order]);

        $details = $repository->getByOrder($order);

        self::assertCount(2, $details);
        self::assertEquals(10, $details[10]['id_order_detail']);
        self::assertEquals(11.08, $details[10]['amount']);
        self::assertEquals(20, $details[10]['rate']);
        self::assertEquals(11, $details[11]['id_order_detail']);
        self::assertEquals(1.49, $details[11]['amount']);
        self::assertEquals(20, $details[11]['rate']);
    }
}
