<?php

namespace Myvetshop\Module\Clinique\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Starting migration of Clinique object to doctrine (read-only for now)
 *
 * @ORM\Table(name="ps_myvetshop_clinique")
 *
 * @ORM\Entity(repositoryClass="Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository")
 */
class MyvetshopClinique
{
    /**
     * @ORM\Id()
     *
     * @ORM\Column(name="id_myvetshop_clinique", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected ?int $id = null;

    /**
     * @ORM\Column(name="id_employee", type="integer", nullable=true)
     */
    public ?int $idEmployee = null;

    /**
     * @ORM\Column(name="id_carrier", type="integer", nullable=true)
     */
    public ?int $idCarrier = null;

    /**
     * @ORM\Column(name="id_carrier_home", type="integer", nullable=true)
     */
    public ?int $idCarrierHome = null;

    /**
     * @ORM\Column(name="id_group", type="integer", nullable=true)
     */
    public ?int $idGroup = null;

    /**
     * @ORM\Column(name="id_group_rural", type="integer", nullable=true)
     */
    public ?int $idGroupRural = null;

    /**
     * @ORM\Column(name="id_store", type="integer", nullable=true)
     */
    public ?int $idStore = null;

    /**
     * @ORM\Column(name="id_theme", type="integer", nullable=true)
     */
    public ?int $idTheme = null;

    /**
     * @ORM\Column(name="name", type="string", nullable=true)
     */
    public ?string $name = null;

    /**
     * @ORM\Column(name="code_privilege", type="string", length=10, nullable=false)
     */
    public string $codePrivilege;

    /**
     * @ORM\Column(name="centrale", type="string", length=10, nullable=false)
     */
    public string $centrale;

    /**
     * @ORM\Column(name="id_warehouse", type="integer", nullable=true)
     */
    public ?int $idWarehouse = null;

    /**
     * @ORM\Column(name="code_client", type="string", length=10, nullable=true)
     */
    public ?string $codeClient = null;

    /**
     * @ORM\Column(name="mdp", type="string", length=10, nullable=true)
     */
    public ?string $mdp = null;

    /**
     * @ORM\Column(name="code_filiere", type="string", length=10, nullable=true)
     */
    public ?string $codeFiliere = null;

    /**
     * @ORM\Column(name="theme", type="string", length=10, nullable=true)
     */
    public ?string $theme = null;

    /**
     * @ORM\Column(name="masquer_logo", type="boolean", nullable=false)
     */
    public bool $masquerLogo = false;

    /**
     * @ORM\Column(name="email_delivery_notes", type="boolean", nullable=false)
     */
    public bool $emailDeliveryNotes = false;

    /**
     * @ORM\Column(name="email_factures", type="boolean", nullable=false)
     */
    public bool $emailFactures = false;

    /**
     * @ORM\Column(name="email_original", type="string", length=150, nullable=true)
     */
    public ?string $emailOriginal = null;

    /**
     * @ORM\Column(name="url_rendez_vous", type="string", length=250, nullable=true)
     */
    public ?string $urlRendezVous = null;

    /**
     * @ORM\Column(name="message", type="text", nullable=true)
     */
    public ?string $message = null;

    /**
     * @ORM\Column(name="rurale", type="boolean", nullable=true)
     */
    public ?bool $rurale = false;

    /**
     * @ORM\Column(name="apiKey", type="string", length=64, nullable=true)
     */
    public ?string $apiKey = null;

    /**
     * @ORM\Column(name="deleted", type="boolean", nullable=false)
     */
    public bool $deleted = false;

    /**
     * List of product ids separated by commas of products the customers can't add to cart
     *
     * @ORM\Column(name="blockedProducts", type="text", nullable=true)
     */
    public ?string $blockedProducts = null;

    /**
     * Message displayed to customer when they try to add a blocked product
     *
     * @ORM\Column(name="blockedProductsMessage", type="text", nullable=true)
     */
    public ?string $blockedProductsMessage = null;

    /**
     * @ORM\Column(name="don", type="boolean", nullable=true)
     */
    public ?bool $don = false;

    /**
     * @ORM\OneToMany(targetEntity="MyvetshopCliniqueHolidays", mappedBy="clinique")
     *
     * @var Collection<int, MyvetshopCliniqueHolidays>
     */
    protected Collection $holidays;

    /**
     * @ORM\OneToMany(targetEntity="MyvetshopExportProduct", mappedBy="clinique")
     *
     * @var Collection<int, MyvetshopExportProduct>
     */
    protected Collection $exportProducts;

    /**
     * @ORM\OneToOne(targetEntity="MyvetshopCliniqueShipping", mappedBy="clinique")
     */
    public ?MyvetshopCliniqueShipping $shipping = null;

    public function __construct()
    {
        $this->holidays = new ArrayCollection();
        $this->exportProducts = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    /**
     * @return Collection<int, MyvetshopCliniqueHolidays>
     */
    public function getHolidays(): Collection
    {
        return $this->holidays;
    }

    /**
     * @return Collection<int, MyvetshopExportProduct>
     */
    public function getExportProducts(): Collection
    {
        return $this->exportProducts;
    }
}
