<?php

declare(strict_types=1);

class CartController extends CartControllerCore
{
    public function initContent(): void
    {
        if ('show' === \Tools::getValue('action')) {
            if (!$this->context->customer->isLogged()) {
                \Tools::redirect((new Link())->getPageLink('authentication'));
            } elseif (true === $this->areProductsAvailable()) {
                \Tools::redirect((new Link())->getPageLink('order'));
            }
        }

        parent::initContent();
    }
}
