<?php

declare(strict_types=1);

class Product extends ProductCore
{
    /**
     * @var float|null
     */
    public $net_weight;

    /**
     * @param int $id_product
     * @param int $id_product_attribute
     *
     * @return float|string
     */
    public static function computeTarifNormal($id_product, $id_product_attribute = 0)
    {
        $context = \Context::getContext();

        \assert(null !== $context);
        \assert(null !== $context->currency);

        $group = new \Group($context->customer->id_default_group);
        $specific_price = null;

        return (float) \Product::priceCalculation(
            (int) $context->shop->id,
            $id_product,
            $id_product_attribute,
            (int) $context->country->id,
            0,
            '',
            (int) $context->currency->id,
            1,
            1,
            !(1 == $group->price_display_method),
            2,
            false,
            true,
            true,
            $specific_price,
            true,
            $context->customer->id,
            true
        );
    }

    /**
     * @param int $id_product
     *
     * @return float|string
     */
    public static function computeTarifNormalMinimum($id_product)
    {
        $id_product_attribute = \Db::getInstance(false)->executeS(
            'SELECT id_product_attribute FROM ps_product_attribute WHERE id_product = ' . (int) $id_product . ' ORDER BY wholesale_price ASC LIMIT 1'
        );

        if (!\is_array($id_product_attribute)) {
            $id_product_attribute = [];
        }

        if (0 == \count($id_product_attribute)) {
            $id_product_attribute = ['id_product_attribute' => 0];
        }

        return self::computeTarifNormal($id_product, $id_product_attribute[0]['id_product_attribute']);
    }

    /**
     * @param int $id_product
     * @param int $id_product_attribute
     *
     * @return float|string
     */
    public static function computeTarifPrivilege($id_product, $id_product_attribute = 0)
    {
        $context = \Context::getContext();

        \assert(null !== $context);
        \assert(null !== $context->currency);

        $group = new \Group($context->customer->id_default_group);
        $specific_price = null;

        return (float) \Product::priceCalculation(
            (int) $context->shop->id,
            $id_product,
            $id_product_attribute,
            (int) $context->country->id,
            0,
            '',
            (int) $context->currency->id,
            4,
            1,
            !(1 == $group->price_display_method),
            2,
            false,
            true,
            true,
            $specific_price,
            true,
            $context->customer->id,
            true
        );
    }

    /**
     * @param int $id_product
     * @param int $id_product_attribute
     *
     * @return float|string
     */
    public static function computeTarifFardelage($id_product, $id_product_attribute = 0)
    {
        $context = \Context::getContext();

        \assert(null !== $context);
        \assert(null !== $context->currency);

        $group = new \Group($context->customer->id_default_group);
        $specific_price = null;

        return (float) \Product::priceCalculation(
            (int) $context->shop->id,
            $id_product,
            $id_product_attribute,
            (int) $context->country->id,
            0,
            '',
            (int) $context->currency->id,
            4,
            2,
            !(1 == $group->price_display_method),
            2,
            false,
            true,
            true,
            $specific_price,
            true
        );
    }

    /**
     * @param int $id_product
     *
     * @return float|string
     */
    public static function computeTarifPrivilegeMinimum($id_product)
    {
        $id_product_attribute = \Db::getInstance(false)->executeS(
            'SELECT id_product_attribute FROM ps_product_attribute WHERE id_product = ' . (int) $id_product . ' ORDER BY wholesale_price ASC LIMIT 1'
        );

        if (!\is_array($id_product_attribute)) {
            $id_product_attribute = [];
        }

        if (0 == \count($id_product_attribute)) {
            $id_product_attribute = ['id_product_attribute' => 0];
        }

        return self::computeTarifPrivilege($id_product, $id_product_attribute[0]['id_product_attribute']);
    }

    /**
     * @return numeric-string|float
     */
    public function getReductionPrivilege()
    {
        return \GroupReduction::getValueForProduct($this->id, 4);
    }

    /**
     * @param int $id_product
     *
     * @return float|string|null
     */
    public static function getMinNetWeight($id_product)
    {
        $cache = \Cache::getInstance();
        $context = \Context::getContext();

        \assert(null !== $context);

        $cache_key = 'Product::getMinWeight-' . $id_product;
        if (!$cache->exists($cache_key)) {
            $min_net_weight = null;

            $product = new Product($id_product, true, $context->language->id, $context->shop->id);

            if ($product->hasCombinations()) {
                $combinations = $product->getAttributeCombinations($context->language->id);

                // Trouve la combination la plus légère
                if (\is_array($combinations) && \count($combinations)) {
                    foreach ($combinations as $combination) {
                        $combination = new \Combination((int) $combination['id_product_attribute']);

                        \assert(\property_exists($combination, 'net_weight'));

                        if (null === $min_net_weight || \floatval($combination->net_weight) < $min_net_weight) {
                            $min_net_weight = \floatval($combination->net_weight);
                        }
                    }
                }
            } else {
                \assert(\property_exists($product, 'net_weight'));

                $min_net_weight = \floatval($product->net_weight);
            }

            $cache->set($cache_key, $min_net_weight, 3600);
        } else {
            $min_net_weight = $cache->get($cache_key);

            \assert(\is_string($min_net_weight) || \is_float($min_net_weight));
        }

        return $min_net_weight;
    }
}

Product::$definition['fields']['net_weight'] = [
    'type' => ObjectModel::TYPE_FLOAT,
    'required' => false,
    'validate' => 'isUnsignedFloat',
];
