<?php

namespace App\Tests\A_Unit\Cart\Preventer;

use Myvetshop\Module\Clinique\Cart\Preventer\BlockedProductPreventer;
use Myvetshop\Module\Clinique\Entity\MyvetshopClinique;
use Myvetshop\Module\Clinique\Repository\MyvetshopCliniqueRepository;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;

class BlockedProductPreventerTest extends TestCase
{
    /**
     * @var MyvetshopCliniqueRepository&MockObject
     */
    protected MyvetshopCliniqueRepository $cliniqueRepository;

    protected BlockedProductPreventer $blockedProductPreventer;

    protected function setUp(): void
    {
        $this->cliniqueRepository = $this->getMockBuilder(MyvetshopCliniqueRepository::class)
            ->disableOriginalConstructor()
            ->getMock();

        $this->blockedProductPreventer = new BlockedProductPreventer(
            $this->cliniqueRepository,
            'blocked by your clinic',
        );
    }

    public function testGetErrorMessagePrevented(): void
    {
        $clinique = new MyvetshopClinique();
        $clinique->blockedProducts = '123,456';
        $this->cliniqueRepository
            ->expects($this->once())
            ->method('findByGroupId')
            ->with(1)
            ->willReturn($clinique);

        $customer = $this->getMockBuilder(\Customer::class)
            ->disableOriginalConstructor()
            ->getMock();

        $customer->id_default_group = 1;

        $product = $this->getMockBuilder(\Product::class)
            ->disableOriginalConstructor()
            ->getMock();
        $product->id = 123;

        $cart = $this->getMockBuilder(\Cart::class)
            ->disableOriginalConstructor()
            ->getMock();

        $errorMessage = $this->blockedProductPreventer->getErrorMessage(
            $product,
            0,
            1,
            'up',
            $customer,
            $cart,
        );

        self::assertIsString($errorMessage);
        self::assertNotEmpty($errorMessage);
    }

    public function testGetErrorMessageNotPrevented(): void
    {
        $clinique = new MyvetshopClinique();
        $clinique->blockedProducts = '123,456';
        $this->cliniqueRepository
            ->expects($this->once())
            ->method('findByGroupId')
            ->with(1)
            ->willReturn($clinique);

        $customer = $this->getMockBuilder(\Customer::class)
            ->disableOriginalConstructor()
            ->getMock();

        $customer->id_default_group = 1;

        $product = $this->getMockBuilder(\Product::class)
            ->disableOriginalConstructor()
            ->getMock();
        $product->id = 234;

        $cart = $this->getMockBuilder(\Cart::class)
            ->disableOriginalConstructor()
            ->getMock();

        $errorMessage = $this->blockedProductPreventer->getErrorMessage(
            $product,
            0,
            1,
            'up',
            $customer,
            $cart
        );

        self::assertNull($errorMessage);
    }
}
