<?php

namespace Myvetshop\Module\Clinique\Entity\Factory;

use Myvetshop\Module\Clinique\Api\Crokit\Dto\CrokitRecommandation;
use Myvetshop\Module\Clinique\Entity\Animal;
use Myvetshop\Module\Clinique\Entity\Recommandation;
use Myvetshop\Module\Clinique\Entity\RecommandationProduct;

class RecommandationFactory
{
    public function createRecommandationProduct(
        int $idProduct,
        ?int $quantity,
        ?int $transition
    ): RecommandationProduct {
        $ret = new RecommandationProduct();
        $ret->idProduct = $idProduct;
        $ret->quantity = $quantity;
        $ret->months = $transition;

        return $ret;
    }

    public function fromDto(
        ?Animal $animal,
        CrokitRecommandation $recommandation
    ): Recommandation {
        $ret = new Recommandation();

        if ($animal) {
            $ret->idCustomer = $animal->idCustomer;
            $ret->animal = $animal;
        }
        $ret->codeReco = $recommandation->codeReco;
        $ret->dateReco = $recommandation->date;
        $ret->codeClinique = $recommandation->code;
        $ret->petname = $recommandation->petname;
        $ret->espece = $recommandation->esp;
        $ret->race = $recommandation->race;
        $ret->idGender = false !== \strpos(\strtolower($recommandation->sex), 'femel') ? 2 : 1;
        $ret->activite = $recommandation->act;
        $ret->dateBirth = $recommandation->dob;
        $ret->age = '';
        $ret->stadePhysio = $recommandation->stadePhysio;
        $ret->pathologie = $recommandation->patho;
        $ret->poidsActuel = (string) $recommandation->actualw;
        $ret->poidsIdeal = (string) $recommandation->idealw;
        $ret->be = $recommandation->be ?? 0;
        $ret->nbrAliment = $recommandation->nbrAliment;
        $ret->productIdMvs1 = $recommandation->productIDmvs1;
        $ret->productIdMvs2 = $recommandation->productIDmvs2;
        $ret->productIdMvs3 = $recommandation->productIDmvs3;
        $ret->qteAliment1 = $recommandation->qteAliment1;
        $ret->qteAliment2 = $recommandation->qteAliment2;
        $ret->qteAliment3 = $recommandation->qteAliment3;
        $ret->transition12 = $recommandation->transition12;
        $ret->transition23 = $recommandation->transition23;

        $ret->addProduit(
            $this->createRecommandationProduct($ret->productIdMvs1, $ret->qteAliment1, null)
        );

        if ($ret->nbrAliment > 1 && null !== $ret->productIdMvs2) {
            $ret->addProduit(
                $this->createRecommandationProduct($ret->productIdMvs2, $ret->qteAliment2, $ret->transition12)
            );
        }

        if ($ret->nbrAliment > 2 && null !== $ret->productIdMvs3) {
            $ret->addProduit(
                $this->createRecommandationProduct($ret->productIdMvs3, $ret->qteAliment3, $ret->transition23)
            );
        }

        return $ret;
    }
}
