<?php

namespace Myvetshop\Module\Clinique\Command\Migrate;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class RemoveRecommendedPrice extends Command
{
    private \Db $db;

    public function __construct(\Db $db)
    {
        parent::__construct('app:migrate:remove-recommended-price');

        $this->db = $db;
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $styledOutput = new SymfonyStyle($input, $output);

        $styledOutput->writeln('Removing group reduction');
        if (!$this->db->execute('TRUNCATE TABLE ' . _DB_PREFIX_ . 'group_reduction')) {
            $styledOutput->error('Error while truncating group_reduction table');

            return 1;
        }

        $styledOutput->writeln('Removing forced prices specific_prices table');
        if (!$this->db->execute('DELETE FROM ' . _DB_PREFIX_ . 'specific_prices WHERE from_quantity = 2')) {
            $styledOutput->error('Error while purging specific_prices table');

            return 1;
        }

        $styledOutput->writeln('Nulling tarif_privilege in ps_myvetshop_tarif_specifique table');
        if (!$this->db->execute('UPDATE ' . _DB_PREFIX_ . 'ps_myvetshop_tarif_specifique SET tarif_privilege = NULL')) {
            $styledOutput->error('Error while purging ps_myvetshop_tarif_specifique table');

            return 1;
        }

        return 0;
    }
}
