<?php

declare(strict_types=1);

if (!\defined('_PS_VERSION_')) {
    exit;
}

function syncOrderState(OrderState $definition): void
{
    $db = Db::getInstance();

    $db->execute('INSERT IGNORE INTO `' . _DB_PREFIX_ . 'order_state` '
        . '(id_order_state, invoice, send_email, module_name, color, unremovable, hidden, logable, delivery, shipped, paid, pdf_invoice, pdf_delivery, deleted)'
        . ' VALUES '
        . ' ('
        . ' ' . (int) $definition->id . ','
        . ' ' . (int) $definition->invoice . ','
        . ' ' . (int) $definition->send_email . ','
        . ' "myvetshopclinique",'
        . ' "' . $db->escape($definition->color) . '",'
        . ' ' . (int) $definition->unremovable . ','
        . ' ' . (int) $definition->hidden . ','
        . ' ' . (int) $definition->logable . ','
        . ' ' . (int) $definition->delivery . ','
        . ' ' . (int) $definition->shipped . ','
        . ' ' . (int) $definition->paid . ','
        . ' ' . (int) $definition->pdf_invoice . ','
        . ' ' . (int) $definition->pdf_delivery . ','
        . ' ' . (int) $definition->deleted . ')'
    );

    $orderState = new OrderState($definition->id);
    if (!Validate::isLoadedObject($orderState)) {
        throw new LogicException('Error while syncing OrderState ' . $definition->id);
    }

    $updated = false;
    if ((bool) $orderState->invoice !== (bool) $definition->invoice) {
        $updated = true;
        $orderState->invoice = (bool) $definition->invoice;
    }
    if ((bool) $orderState->send_email !== (bool) $definition->send_email) {
        $updated = true;
        $orderState->send_email = (bool) $definition->send_email;
    }
    if ($orderState->module_name !== 'myvetshopclinique') {
        $updated = true;
        $orderState->module_name = 'myvetshopclinique';
    }
    if ($orderState->color !== $definition->color) {
        $updated = true;
        $orderState->color = $definition->color;
    }
    if ((bool) $orderState->unremovable !== (bool) $definition->unremovable) {
        $updated = true;
        $orderState->unremovable = (bool) $definition->unremovable;
    }
    if ((bool) $orderState->hidden !== (bool) $definition->hidden) {
        $updated = true;
        $orderState->hidden = (bool) $definition->hidden;
    }
    if ((bool) $orderState->logable !== (bool) $definition->logable) {
        $updated = true;
        $orderState->logable = (bool) $definition->logable;
    }
    if ((bool) $orderState->delivery !== (bool) $definition->delivery) {
        $updated = true;
        $orderState->delivery = (bool) $definition->delivery;
    }
    if ((bool) $orderState->shipped !== (bool) $definition->shipped) {
        $updated = true;
        $orderState->shipped = (bool) $definition->shipped;
    }
    if ((bool) $orderState->paid !== (bool) $definition->paid) {
        $updated = true;
        $orderState->paid = (bool) $definition->paid;
    }
    if ((bool) $orderState->pdf_invoice !== (bool) $definition->pdf_invoice) {
        $updated = true;
        $orderState->pdf_invoice = (bool) $definition->pdf_invoice;
    }
    if ((bool) $orderState->pdf_delivery !== (bool) $definition->pdf_delivery) {
        $updated = true;
        $orderState->pdf_delivery = (bool) $definition->pdf_delivery;
    }
    if ((bool) $orderState->deleted !== (bool) $definition->deleted) {
        $updated = true;
        $orderState->deleted = (bool) $definition->deleted;
    }
    foreach ($definition->name as $idLang => $value) {
        if ($orderState->name[$idLang] ?? null !== $value) {
            $updated = true;
            $orderState->name[$idLang] = $value;
        }
    }

    if (\is_array($definition->template)) {
        foreach ($definition->template as $idLang => $value) {
            if ($orderState->template[$idLang] ?? null !== $value) {
                $updated = true;
                $orderState->template[$idLang] = $value;
            }
        }
    }

    if ($updated) {
        $orderState->save();
    }
}

function upgrade_module_4_2_38(myvetshopclinique $module): bool
{
    $db = Db::getInstance();

    $query = 'ALTER TABLE `' . _DB_PREFIX_ . 'myvetshop_clinique`
            ADD COLUMN IF NOT EXISTS `email_delivery_notes` int(1) NOT NULL DEFAULT 1,
            ADD COLUMN IF NOT EXISTS `blockedProducts` TEXT DEFAULT NULL,
            ADD COLUMN IF NOT EXISTS `blockedProductsMessage` TEXT DEFAULT NULL';

    if (!$db->execute($query)) {
        return false;
    }

    // Ajout des OrderStates spécifiques
    $frIdLang = Language::getIdByIso('fr');
    $enIdLang = Language::getIdByIso('en');

    // 15 - Archivé
    $archivedOrderState = new OrderState();
    $archivedOrderState->id = 15;
    $archivedOrderState->invoice = false;
    $archivedOrderState->send_email = false;
    $archivedOrderState->module_name = 'myvetshopclinique';
    $archivedOrderState->color = '#01b887';
    $archivedOrderState->unremovable = true;
    $archivedOrderState->hidden = false;
    $archivedOrderState->logable = true;
    $archivedOrderState->delivery = false;
    $archivedOrderState->shipped = true;
    $archivedOrderState->paid = true;
    $archivedOrderState->pdf_invoice = false;
    $archivedOrderState->pdf_delivery = false;
    $archivedOrderState->deleted = false;
    $archivedOrderState->template = [];
    if ($enIdLang) {
        $archivedOrderState->name[$enIdLang] = 'Archived';
    }
    if ($frIdLang) {
        $archivedOrderState->name[$frIdLang] = 'Archivé';
    }

    syncOrderState($archivedOrderState);

    // 16 - Disponible à la clinique
    $clinicOrderState = new OrderState();
    $clinicOrderState->id = 16;
    $clinicOrderState->invoice = true;
    $clinicOrderState->send_email = true;
    $clinicOrderState->module_name = 'myvetshopclinique';
    $clinicOrderState->color = '#1c77fa';
    $clinicOrderState->unremovable = true;
    $clinicOrderState->hidden = false;
    $clinicOrderState->logable = true;
    $clinicOrderState->delivery = false;
    $clinicOrderState->shipped = true;
    $clinicOrderState->paid = true;
    $clinicOrderState->pdf_invoice = false;
    $clinicOrderState->pdf_delivery = false;
    $clinicOrderState->deleted = false;
    $clinicOrderState->template = [];
    if ($enIdLang) {
        $clinicOrderState->name[$enIdLang] = 'Available at the clinic';
    }
    if ($frIdLang) {
        $clinicOrderState->name[$frIdLang] = 'Disponible à la clinique';
    }

    syncOrderState($clinicOrderState);

    // 17 - Avoir
    $clinicOrderState = new OrderState();
    $clinicOrderState->id = 17;
    $clinicOrderState->invoice = true;
    $clinicOrderState->send_email = false;
    $clinicOrderState->module_name = 'myvetshopclinique';
    $clinicOrderState->color = '#ec2e15';
    $clinicOrderState->unremovable = true;
    $clinicOrderState->hidden = false;
    $clinicOrderState->logable = false;
    $clinicOrderState->delivery = false;
    $clinicOrderState->shipped = false;
    $clinicOrderState->paid = false;
    $clinicOrderState->pdf_invoice = false;
    $clinicOrderState->pdf_delivery = false;
    $clinicOrderState->deleted = false;
    $clinicOrderState->template = [];
    if ($enIdLang) {
        $clinicOrderState->name[$enIdLang] = 'Order Slip';
        $clinicOrderState->template[$enIdLang] = 'refund';
    }
    if ($frIdLang) {
        $clinicOrderState->name[$frIdLang] = 'Avoir';
        $clinicOrderState->template[$frIdLang] = 'refund';
    }

    syncOrderState($clinicOrderState);

    // 18 - Retrait effectué
    $clinicOrderState = new OrderState();
    $clinicOrderState->id = 18;
    $clinicOrderState->invoice = true;
    $clinicOrderState->send_email = false;
    $clinicOrderState->module_name = 'myvetshopclinique';
    $clinicOrderState->color = '#005414';
    $clinicOrderState->unremovable = true;
    $clinicOrderState->hidden = false;
    $clinicOrderState->logable = true;
    $clinicOrderState->delivery = false;
    $clinicOrderState->shipped = true;
    $clinicOrderState->paid = true;
    $clinicOrderState->pdf_invoice = false;
    $clinicOrderState->pdf_delivery = false;
    $clinicOrderState->deleted = false;
    $clinicOrderState->template = [];
    if ($enIdLang) {
        $clinicOrderState->name[$enIdLang] = 'Order retrieved';
    }
    if ($frIdLang) {
        $clinicOrderState->name[$frIdLang] = 'Retrait effectué';
    }

    syncOrderState($clinicOrderState);

    return true;
}
