<?php

namespace Myvetshop\Module\Clinique\Domain\ProductAttribute;

class ProductAttributeSorter
{
    /**
     * @param array<mixed> $a
     * @param array<mixed> $b
     *
     * @return int
     */
    public static function productAttributeComparator(array $a, array $b): int
    {
        if ($a['weight'] > $b['weight']) {
            return 1;
        } elseif ($a['weight'] < $b['weight']) {
            return -1;
        }

        return 0;
    }

    /**
     * @param array<array<mixed>> $combinations
     */
    public static function sort(array &$combinations): void
    {
        \uasort($combinations, [self::class, 'productAttributeComparator']);
    }
}
