<?php

namespace Myvetshop\Module\Clinique\Command;

use Myvetshop\Module\Clinique\Cron\CronTaskInterface;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class CronDailyCommand extends Command
{
    /**
     * @var iterable<CronTaskInterface>
     */
    private $tasks;

    /**
     * @param iterable<CronTaskInterface> $tasks
     */
    public function __construct(
        iterable $tasks
    ) {
        $this->tasks = $tasks;

        parent::__construct('app:cron:daily');
    }

    public function execute(InputInterface $input, OutputInterface $output): int
    {
        $styledOutput = new SymfonyStyle($input, $output);

        foreach ($this->tasks as $task) {
            $styledOutput->writeln(sprintf('Running task %s', get_class($task)));
            $task->run($output);
        }

        return 0;
    }
}
