<?php

namespace Myvetshop\Module\Clinique\Adapter\Factory;

class SpecificPriceFactory
{
    public function createEntity(): \SpecificPrice
    {
        return new \SpecificPrice();
    }

    public function create(
        int $idProduct,
        int $idProductAttribute,
        int $quantity,
        float $amount,
        int $groupId,
        float $groupReduction
    ): \SpecificPrice {
        $amountFinal = \round($amount / (1 - $groupReduction), 2);

        $ret = $this->createEntity();

        $ret->id_cart = 0;
        $ret->id_product = $idProduct;
        $ret->id_shop = 0;
        $ret->id_shop_group = 0;
        $ret->id_currency = 0;
        $ret->id_country = 0;
        $ret->id_customer = 0;
        $ret->id_product_attribute = $idProductAttribute;
        $ret->id_group = $groupId;
        $ret->from_quantity = $quantity;
        $ret->reduction = 0;
        $ret->reduction_tax = 1;
        $ret->reduction_type = 'amount';
        $ret->price = $amountFinal;
        $ret->from = '0000-00-00 00:00:00';
        $ret->to = '0000-00-00 00:00:00';

        return $ret;
    }
}
