<?php

namespace Myvetshop\Module\Clinique\Import\Serializer;

use Myvetshop\Module\Clinique\Import\Model\OrderModel;
use Symfony\Component\Serializer\Normalizer\DenormalizerInterface;

class OrderModelNormalizer implements DenormalizerInterface
{
    /**
     * @param array<mixed> $context
     *
     * @return OrderModel
     */
    public function denormalize($data, $type, $format = null, array $context = [])
    {
        if (!\is_array($data)) {
            throw new \Exception('Invalid JSON data');
        }

        $ret = new OrderModel();

        $ret->email = $data['email'];
        $ret->idOrder = \intval($data['id_order']);
        $ret->reference = $data['reference'];
        $ret->idShopGroup = \intval($data['id_shop_group']);
        $ret->idShop = \intval($data['id_shop']);
        $ret->idCarrier = \intval($data['id_carrier']);
        $ret->idLang = \intval($data['id_lang']);
        $ret->idCustomer = \intval($data['id_customer']);
        $ret->idCart = \intval($data['id_cart']);
        $ret->idCurrency = \intval($data['id_currency']);
        $ret->idAddressDelivery = \intval($data['id_address_delivery']);
        $ret->idAddressInvoice = \intval($data['id_address_invoice']);
        // $ret->idStore = \intval($data['id_store']);
        $ret->currentState = \intval($data['current_state']);
        $ret->secureKey = $data['secure_key'];
        $ret->payment = $data['payment'];
        $ret->conversionRate = $data['conversion_rate'];
        $ret->module = $data['module'];
        $ret->recyclable = \boolval($data['recyclable']);
        $ret->gift = \boolval($data['gift']);
        $ret->giftMessage = $data['gift_message'];
        $ret->mobileTheme = \boolval($data['mobile_theme']);
        $ret->shippingNumber = $data['shipping_number'] ?: null;
        $ret->totalDiscounts = $data['total_discounts'];
        $ret->totalDiscountsTaxIncl = $data['total_discounts_tax_incl'];
        $ret->totalDiscountsTaxExcl = $data['total_discounts_tax_excl'];
        $ret->totalPaid = $data['total_paid'];
        $ret->totalPaidTaxIncl = $data['total_paid_tax_incl'];
        $ret->totalPaidTaxExcl = $data['total_paid_tax_excl'];
        $ret->totalPaidReal = $data['total_paid_real'];
        $ret->totalProducts = $data['total_products'];
        $ret->totalProductsWt = $data['total_products_wt'];
        $ret->totalShipping = $data['total_shipping'];
        $ret->totalShippingTaxIncl = $data['total_shipping_tax_incl'];
        $ret->totalShippingTaxExcl = $data['total_shipping_tax_excl'];
        $ret->carrierTaxRate = $data['carrier_tax_rate'];
        $ret->totalWrapping = $data['total_wrapping'];
        $ret->totalWrappingTaxIncl = $data['total_wrapping_tax_incl'];
        $ret->totalWrappingTaxExcl = $data['total_wrapping_tax_excl'];
        $ret->roundMode = \intval($data['round_mode']);
        $ret->roundType = \intval($data['round_type']);
        $ret->invoiceNumber = \intval($data['invoice_number']);
        $ret->deliveryNumber = $data['delivery_number'] ?: null;
        $ret->invoiceDate = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['invoice_date'])
            ?: null;
        $ret->deliveryDate = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['delivery_date'])
            ?: null;
        $ret->valid = \boolval($data['valid']);
        $ret->dateAdd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_add'])
            ?: new \DateTimeImmutable();
        $ret->dateUpd = \DateTimeImmutable::createFromFormat('Y-m-d H:i:s', $data['date_upd'])
            ?: new \DateTimeImmutable();

        return $ret;
    }

    public function supportsDenormalization($data, $type, $format = null)
    {
        return OrderModel::class === $type;
    }
}
